/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser.actions;

import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.ui.processrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.processrepositorybrowser.RepositoryTemplateInput;
import de.aristaflow.adept2.ui.processrepositorybrowser.actions.AbstractTemplateProxyAction;
import de.aristaflow.adept2.ui.processrepositorybrowser.wizards.ReleaseTemplateWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ReleaseTemplateAction
extends AbstractTemplateProxyAction {
    public void run(IAction action) {
        RepositoryTemplateInput input = new RepositoryTemplateInput(this.getRepository(), this.getSelection().getID(), false);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = window.getActivePage();
        IEditorPart editor = activePage.findEditor((IEditorInput)input);
        if (editor != null) {
            String title = "Template open";
            String msg = "The template editor needs to be closed. Do you want to save and close the template?";
            boolean saveAndContinue = MessageDialog.openQuestion((Shell)window.getShell(), (String)title, (String)msg);
            if (!saveAndContinue) {
                return;
            }
            if (!activePage.closeEditor(editor, true)) {
                return;
            }
        }
        ProcessManager processManager = Activator.getService().getProcessManager();
        ReleaseTemplateWizard wizard = new ReleaseTemplateWizard(this.getRepository(), processManager, this.getSelection());
        WizardDialog dialogue = new WizardDialog(this.view.getSite().getShell(), (IWizard)wizard);
        if (dialogue.open() == 0) {
            this.view.update();
        }
    }

    @Override
    protected void selectionChanged(IAction action, TemplateProxy proxy) {
        action.setEnabled(proxy != null && proxy.getBuildtimeState() == ProcessConstants.TemplateBuildtimeState.VALID);
    }
}

