/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser.actions;

import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.ui.processrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.processrepositorybrowser.actions.AbstractTemplateProxyAction;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.LockException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;

public class UnlockTemplateAction
extends AbstractTemplateProxyAction {
    public void run(IAction action) {
        String title = "Unlock Template ...";
        String message = "Removing the lock might make it impossible for others to commit their changes. Do you really want to remove the lock?";
        MessageDialog dialogue = new MessageDialog(this.view.getSite().getShell(), title, null, message, 3, new String[]{"Unlock", "Keep Lock"}, 1);
        if (dialogue.open() == 1) {
            return;
        }
        try {
            this.getRepository().getTemplateManager().unlockTemplate(Activator.getService().getSessionToken(), this.getSelection().getID());
        }
        catch (LockException ex) {
            String msg = "Unlock failed due to a LockException!";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
        }
    }

    @Override
    protected void selectionChanged(IAction action, TemplateProxy proxy) {
        if (proxy == null) {
            action.setEnabled(false);
        } else {
            action.setEnabled(true);
        }
    }
}

