/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser.actions;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.ui.processrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.processrepositorybrowser.actions.AbstractTemplateProxyAction;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LockException;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

public class ValidateTemplateAction
extends AbstractTemplateProxyAction {
    @Override
    protected void selectionChanged(IAction action, TemplateProxy proxy) {
        if (proxy.getBuildtimeState() == ProcessConstants.TemplateBuildtimeState.IN_CONSTRUCTION) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    public void run(IAction action) {
        SessionToken session = Activator.getService().getSessionToken();
        try {
            CheckReport report = this.getRepository().getTemplateManager().validateTemplate(session, this.getSelection().getID());
            if (report.getCheckResult() != CheckReport.ResultType.OK && report.getCheckResult() != CheckReport.ResultType.INFO) {
                MessageBox msg = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
                msg.setMessage("Validation failed! Result: " + report.getCheckResult() + report.getReportSummary());
                msg.open();
                return;
            }
            MessageBox msg = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 34);
            if (report.getCheckResult() == CheckReport.ResultType.OK) {
                msg.setMessage("Validation successful. Result: " + report.getCheckResult());
            } else {
                msg.setMessage("Validation successful. Result: " + report.getCheckResult() + report.getReportSummary());
            }
            msg.open();
        }
        catch (LockException e) {
            String message = "LockException while validating the template!";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
        }
        this.view.update();
    }
}

