/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser.views;

import de.aristaflow.adept2.core.processrepository.ProcessRepository;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessType;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.ui.icons.MiscImages;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processediting.editorinputs.TransientTemplateInput;
import de.aristaflow.adept2.ui.processrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.processrepositorybrowser.RepositoryTemplateEditor;
import de.aristaflow.adept2.ui.processrepositorybrowser.RepositoryTemplateInput;
import de.aristaflow.adept2.ui.processrepositorybrowser.views.ProcessRepositoryContentProvider;
import de.aristaflow.adept2.ui.processrepositorybrowser.views.ProcessRepositoryTreeWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ProcessRepositoryBrowserView
extends ViewPart
implements ITabbedPropertySheetPageContributor {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".views.ProcessRepositoryBrowserView";
    public static final String CONTEXTMENU_ID = String.valueOf(Activator.getPluginID()) + ".views.ProcessRepositoryBrowserView.popupmenu";
    protected ProcessRepositoryTreeWidget tree;
    private ProcessRepositoryContentProvider contentProvider;
    TreeViewer treeViewer;
    private ProcessRepository repository;

    public ProcessRepositoryBrowserView() {
        ImageDescriptor[] overlays = new ImageDescriptor[5];
        overlays[3] = MiscImages.IMG_REPOSITORY_OV;
        DecorationOverlayIcon imageDescriptor = new DecorationOverlayIcon(MiscImages.IMG_TEMPLATE2.createImage(), overlays);
        this.setTitleImage(imageDescriptor.createImage());
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.repository = Activator.getService().getProcessRepository();
        this.tree = new ProcessRepositoryTreeWidget(parent, 0);
        if (!(this.tree.getColumnViewer() instanceof TreeViewer)) {
            throw new RuntimeException("No TreeViewer available through ListUIComponent!");
        }
        this.treeViewer = (TreeViewer)this.tree.getColumnViewer();
        this.contentProvider = new ProcessRepositoryContentProvider(this.repository);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tree.setInput("");
        MenuManager menuManager = this.tree.getContextMenu();
        this.getSite().registerContextMenu(CONTEXTMENU_ID, menuManager, (ISelectionProvider)this.tree.getColumnViewer());
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object sel = ((ITreeSelection)ProcessRepositoryBrowserView.this.treeViewer.getSelection()).getFirstElement();
                if (sel instanceof TemplateProxy) {
                    TemplateProxy proxy = (TemplateProxy)sel;
                    ProcessRepositoryBrowserView.this.openTemplateProxyEditor(proxy, false);
                }
            }
        });
        this.treeViewer.expandToLevel(2);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
    }

    public void setFocus() {
        this.tree.getControl().setFocus();
    }

    public void openTemplateProxyEditor(TemplateProxy proxy, boolean deriveNewChild) {
        if (proxy.getBuildtimeState() != ProcessConstants.TemplateBuildtimeState.RELEASED || deriveNewChild) {
            try {
                RepositoryTemplateInput input = new RepositoryTemplateInput(this.repository, proxy.getID(), deriveNewChild);
                input.addTemplateChangeListener(new RepositoryTemplateInput.TemplateChangeListener(){

                    @Override
                    public void templateSaved(Template template) {
                        ProcessRepositoryBrowserView.this.update();
                    }
                });
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, RepositoryTemplateEditor.ID);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        } else {
            Template template = this.repository.getTemplateManager().getTemplate(Activator.getService().getSessionToken(), proxy.getID());
            TransientTemplateInput input = new TransientTemplateInput(template);
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, Editor.ID);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public void update() {
        List<Object> expandedObjects = Arrays.asList(this.treeViewer.getExpandedElements());
        this.treeViewer.refresh();
        for (Object obj : expandedObjects) {
            this.treeViewer.getTree().update();
            TreeItem[] treeItemArray = this.treeViewer.getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                this.expandItemInTree(item, obj);
                ++n2;
            }
        }
    }

    private boolean expandItemInTree(TreeItem rootItem, Object element) {
        TreeItem subItem;
        TreeItem[] treeItemArray = rootItem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            subItem = treeItemArray[n2];
            if (this.isItemOfElement(subItem, element)) {
                ArrayList<Object> newObjs = new ArrayList<Object>(Arrays.asList(this.treeViewer.getExpandedElements()));
                newObjs.add(subItem.getData());
                this.treeViewer.setExpandedElements(newObjs.toArray(new Object[newObjs.size()]));
                return true;
            }
            ++n2;
        }
        treeItemArray = rootItem.getItems();
        n = treeItemArray.length;
        n2 = 0;
        while (n2 < n) {
            subItem = treeItemArray[n2];
            if (this.expandItemInTree(subItem, element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isItemOfElement(TreeItem rootItem, Object element) {
        Object itemData = rootItem.getData();
        if (itemData == null) {
            return false;
        }
        if (itemData.getClass().equals(element.getClass())) {
            if (element instanceof String && element.equals(itemData)) {
                return true;
            }
            if (element instanceof ProcessType ? ((ProcessType)element).getName().equals(((ProcessType)itemData).getName()) : element instanceof TemplateProxy && ((TemplateProxy)element).getID().equals(((TemplateProxy)itemData).getID())) {
                return true;
            }
        }
        return false;
    }

    public void update(Object ... elements) {
        this.treeViewer.update(elements, null);
    }

    public String getContributorId() {
        return "de.aristaflow.adept2.ui.processvisualisation.ProcessVisualiser";
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(type);
    }

    public void showFullHierarchyTree(boolean show) {
        this.contentProvider.setShowFullHierarchy(show);
        this.treeViewer.refresh();
    }
}

