/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser.views;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.processrepository.ProcessRepository;
import de.aristaflow.adept2.model.processmodel.ProcessType;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.ui.processrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.processrepositorybrowser.model.TreeParent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ProcessRepositoryContentProvider
implements ITreeContentProvider {
    private ProcessRepository processRepository;
    private boolean showFullHierarchy = false;

    public ProcessRepositoryContentProvider(ProcessRepository processRepository) {
        this.processRepository = processRepository;
    }

    private void getFlatTemplateProxies(TemplateProxy root, List<TemplateProxy> result, SessionToken session) {
        result.add(root);
        List ids = root.getChildTemplateIDs();
        for (UUID id : ids) {
            this.getFlatTemplateProxies(this.processRepository.getTemplateManager().getTemplateProxy(session, id), result, session);
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreeParent) {
            TreeParent treeParent = (TreeParent)parentElement;
            return treeParent.getChildren();
        }
        if (parentElement instanceof ProcessType) {
            if (this.showFullHierarchy) {
                return new Object[]{((ProcessType)parentElement).getRootTemplate()};
            }
            SessionToken session = Activator.getService().getSessionToken();
            TemplateProxy root = this.processRepository.getTemplateManager().getTemplateProxy(session, ((ProcessType)parentElement).getRootTemplate().getID());
            ArrayList<TemplateProxy> items = new ArrayList<TemplateProxy>();
            this.getFlatTemplateProxies(root, items, session);
            return items.toArray();
        }
        if (parentElement instanceof TemplateProxy && this.showFullHierarchy) {
            TemplateProxy parent = (TemplateProxy)parentElement;
            List childTemplateIDs = parent.getChildTemplateIDs();
            ArrayList<TemplateProxy> childTemplates = new ArrayList<TemplateProxy>(childTemplateIDs.size());
            SessionToken session = Activator.getService().getSessionToken();
            for (UUID childTemplate : childTemplateIDs) {
                childTemplates.add(this.processRepository.getTemplateManager().getTemplateProxy(session, childTemplate));
            }
            return childTemplates.toArray(new Object[childTemplates.size()]);
        }
        if (parentElement instanceof String) {
            return this.getProcessTypes().toArray(new Object[this.getProcessTypes().size()]);
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TemplateProxy) {
            if (this.showFullHierarchy) {
                TemplateProxy proxy = (TemplateProxy)element;
                return proxy.getChildTemplateIDs().size() > 0;
            }
            return false;
        }
        if (element instanceof ProcessType) {
            return true;
        }
        return this.getProcessTypes().size() > 0;
    }

    public Object[] getElements(Object inputElement) {
        return new Object[]{this.processRepository.getUniqueRepositoryName()};
    }

    private Set<ProcessType> getProcessTypes() {
        return this.processRepository.getAllProcessTypes(Activator.getService().getSessionToken());
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isShowFullHierarchy() {
        return this.showFullHierarchy;
    }

    public void setShowFullHierarchy(boolean showFullHierarchy) {
        this.showFullHierarchy = showFullHierarchy;
    }
}

