/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser.views;

import de.aristaflow.adept2.core.processrepository.ProcessRepository;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessType;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.ui.icons.MiscImages;
import de.aristaflow.adept2.ui.processrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.list.ListUIComponent;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class ProcessRepositoryTreeWidget
extends ListUIComponent {
    public static final String COLUMN_NAME = "Name";
    public static final String COLUMN_VERSION = "Version";
    public static final String COLUMN_CREATIONTIME = "Creation";
    public static final String COLUMN_MODIFICATION = "Modification";

    public ProcessRepositoryTreeWidget(Composite parent, int style) {
        super(Tree.class, parent, style);
        this.initColumns(new String[]{COLUMN_NAME, COLUMN_VERSION, COLUMN_CREATIONTIME, COLUMN_MODIFICATION}, null, null, true);
    }

    protected void registerColumns() {
        super.registerColumns();
        this.registerColumn(COLUMN_NAME, COLUMN_NAME, 0, new ColumnData(100, 1.0f), (CellLabelProvider)new NameColumnLabelProvider(), null);
        this.registerColumn(COLUMN_VERSION, COLUMN_VERSION, 0, new ColumnData(), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TemplateProxy) {
                    return ((TemplateProxy)element).getInternalVersion();
                }
                return "";
            }
        }, null);
        this.registerColumn(COLUMN_CREATIONTIME, "Created", 0, new ColumnData(0, 1.0f, -1), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TemplateProxy) {
                    return ProcessRepositoryTreeWidget.this.getDateString(((TemplateProxy)element).getCreationTime());
                }
                return "";
            }
        }, null);
        this.registerColumn(COLUMN_MODIFICATION, "Last Modified", 0, new ColumnData(0, 1.0f, -1), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TemplateProxy) {
                    return ProcessRepositoryTreeWidget.this.getDateString(((TemplateProxy)element).getLastModificationTime());
                }
                return "";
            }
        }, null);
    }

    protected void fillContextMenu(MenuManager contextMenu) {
        contextMenu.add((IContributionItem)new Separator("create"));
        contextMenu.add((IContributionItem)new Separator("state"));
        contextMenu.add((IContributionItem)new Separator("eximport"));
        contextMenu.add((IContributionItem)new Separator("unlock"));
        super.fillContextMenu(contextMenu);
    }

    String getDateString(long date) {
        DateFormat formatter = DateFormat.getDateTimeInstance(2, 3, Activator.getService().getActiveAgent().getLocale());
        return date <= 0L ? "Not set" : formatter.format(new Date(date));
    }

    private class NameColumnLabelProvider
    extends ColumnLabelProvider {
        private NameColumnLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof TemplateProxy) {
                TemplateProxy proxy = (TemplateProxy)element;
                ImageDescriptor templateImage = MiscImages.IMG_TEMPLATE2;
                ImageDescriptor[] states = new ImageDescriptor[5];
                switch (proxy.getBuildtimeState()) {
                    case IN_CONSTRUCTION: {
                        states[1] = MiscImages.IMG_EDITED_OV;
                        break;
                    }
                    case VALID: {
                        states[1] = MiscImages.IMG_VALID_OV;
                        break;
                    }
                    case RELEASED: {
                        states[1] = MiscImages.IMG_RELEASED_OV;
                        break;
                    }
                    default: {
                        states[1] = MiscImages.IMG_EMPTY_OV;
                    }
                }
                if (proxy.getBuildtimeState() == ProcessConstants.TemplateBuildtimeState.RELEASED && (proxy.isTopLevelUsable() && !proxy.isInstantiable(false) || proxy.getUsageAsSubprocess() != ProcessConstants.TemplateUsage.NO_SUBPROCESS && !proxy.isInstantiable(true) || !proxy.isTopLevelUsable() && proxy.getUsageAsSubprocess() == ProcessConstants.TemplateUsage.NO_SUBPROCESS)) {
                    states[1] = MiscImages.IMG_NOT_INSTANTIABLE_OV;
                }
                if (proxy.isOutdated(true) && proxy.isOutdated(false)) {
                    states[3] = MiscImages.IMG_OUTDATED_OV;
                }
                DecorationOverlayIcon imageDescriptor = new DecorationOverlayIcon(templateImage.createImage(), states);
                return imageDescriptor.createImage();
            }
            if (element instanceof ProcessType) {
                return MiscImages.IMG_TEMPLATE.createImage();
            }
            if (element instanceof ProcessRepository || element instanceof String) {
                return MiscImages.IMG_REPOSITORY.createImage();
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof TemplateProxy) {
                return ((TemplateProxy)element).getName();
            }
            if (element instanceof ProcessType) {
                return ((ProcessType)element).getName();
            }
            if (element instanceof ProcessRepository) {
                return ((ProcessRepository)element).getUniqueRepositoryName();
            }
            if (element instanceof String) {
                return (String)element;
            }
            return "Unknown element";
        }
    }
}

