/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser.wizards;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.processrepository.ProcessRepository;
import de.aristaflow.adept2.model.processmodel.ProcessType;
import de.aristaflow.adept2.ui.processrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.processrepositorybrowser.RepositoryTemplateEditor;
import de.aristaflow.adept2.ui.processrepositorybrowser.RepositoryTemplateInput;
import de.aristaflow.adept2.ui.processrepositorybrowser.views.ProcessRepositoryBrowserView;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CreateProcessTypeWizard
extends Wizard {
    private final ProcessRepository repository;
    private CreateProcessTypeWizardPage page;
    protected final Set<String> typeNames = new HashSet<String>();
    private final ProcessRepositoryBrowserView view;

    public CreateProcessTypeWizard(ProcessRepository repository, ProcessRepositoryBrowserView view) {
        this.repository = repository;
        this.view = view;
        Set types = repository.getAllProcessTypes(Activator.getService().getSessionToken());
        for (ProcessType type : types) {
            this.typeNames.add(type.getName());
        }
        this.setWindowTitle("Create a new Process Type...");
    }

    public void addPages() {
        super.addPages();
        this.page = new CreateProcessTypeWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        String newTypeName = this.page.txtTypeName.getText();
        SessionToken session = Activator.getService().getSessionToken();
        ProcessType type = this.repository.createProcessType(session, newTypeName);
        if (this.view != null) {
            this.view.openTemplateProxyEditor(type.getRootTemplate(), false);
        } else {
            RepositoryTemplateInput input = new RepositoryTemplateInput(this.repository, type.getRootTemplate().getID(), false);
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, RepositoryTemplateEditor.ID);
            }
            catch (PartInitException e) {
                String message = "The process type has been created but could not be opened for editing.";
                LoggerTools.getLogger((Object)((Object)this)).log(Level.INFO, message, e);
                Status status = new Status(2, Activator.getPluginID(), message);
                ErrorDialog dialogue = new ErrorDialog(this.getShell(), "Failed to open editor", message, (IStatus)status, 2);
                dialogue.open();
                return true;
            }
        }
        return true;
    }

    protected class CreateProcessTypeWizardPage
    extends WizardPage {
        protected Text txtTypeName;

        protected CreateProcessTypeWizardPage() {
            super("Create Process Type");
            this.setTitle("Create a new Process Type...");
            this.setDescription("Enter a process type name which does not exist.");
            this.setPageComplete(false);
        }

        public void createControl(Composite parent) {
            parent.setLayout((Layout)new FillLayout());
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(2, false));
            Label lblDescription = new Label(container, 0);
            lblDescription.setText("Enter the name of the new type:");
            GridData gridData = new GridData(16384, 0x1000000, false, false);
            lblDescription.setLayoutData((Object)gridData);
            this.txtTypeName = new Text(container, 2048);
            gridData = new GridData(4, 4, true, false);
            this.txtTypeName.setLayoutData((Object)gridData);
            this.txtTypeName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String newTypeName = CreateProcessTypeWizardPage.this.txtTypeName.getText();
                    boolean canFinish = false;
                    if (newTypeName.equals("")) {
                        CreateProcessTypeWizardPage.this.setMessage("The type name must not be empty.", 3);
                        canFinish = false;
                    } else if (((CreateProcessTypeWizardPage)CreateProcessTypeWizardPage.this).CreateProcessTypeWizard.this.typeNames.contains(newTypeName)) {
                        CreateProcessTypeWizardPage.this.setMessage("A type with the given name exists already.", 3);
                        canFinish = false;
                    } else {
                        CreateProcessTypeWizardPage.this.setMessage(null);
                        canFinish = true;
                    }
                    CreateProcessTypeWizardPage.this.setPageComplete(canFinish);
                }
            });
            this.setControl((Control)container);
        }
    }
}

