/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser.wizards;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.processrepository.ProcessRepository;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.ui.processrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.LockException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class OutdateTemplateWizard
extends Wizard {
    protected final TemplateProxy proxy;
    private final ProcessRepository repository;
    private OutdateTemplateWizardPage page;

    public OutdateTemplateWizard(ProcessRepository repository, TemplateProxy proxy) {
        this.repository = repository;
        this.proxy = proxy;
        this.setWindowTitle("Outdate template " + proxy.getName());
    }

    public void addPages() {
        super.addPages();
        this.page = new OutdateTemplateWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        SessionToken session = this.getToken();
        boolean ret = false;
        try {
            try {
                try {
                    TemplateStatus status = this.repository.getTemplateManager().getAndLockTemplateStatus(session, this.proxy.getID());
                    String comment = this.page.txtComment.getText();
                    status.setOutdated(this.page.btnOutdateSub.getSelection(), true, comment);
                    status.setOutdated(this.page.btnOutdateTop.getSelection(), false, comment);
                    status.setInstantiable(!this.page.btnUninstSub.getSelection(), true, comment);
                    status.setInstantiable(!this.page.btnUninstTop.getSelection(), false, comment);
                    this.repository.getTemplateManager().setTemplateStatus(session, status);
                    ret = true;
                }
                catch (InvalidTemplateStateException e) {
                    throw new RuntimeException("New template status rejected. Are there templates referencing this one?", e);
                }
            }
            finally {
                this.repository.getTemplateManager().unlockTemplateStatus(session, this.proxy.getID());
            }
        }
        catch (LockException e) {
            String message = "LockException while saving template status!";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
        }
        return ret;
    }

    private SessionToken getToken() {
        return Activator.getService().getSessionToken();
    }

    protected class OutdateTemplateWizardPage
    extends WizardPage
    implements SelectionListener {
        protected Button btnOutdateSub;
        protected Button btnUninstSub;
        protected Button btnUninstTop;
        protected Button btnOutdateTop;
        Text txtComment;

        protected OutdateTemplateWizardPage() {
            super("Outdate Template");
            this.setTitle("Change the outdated / instantiable settings");
            this.setDescription("Change the outdated and instantiable settings of template " + OutdateTemplateWizard.this.proxy.getName());
        }

        public void createControl(Composite parent) {
            parent.setLayout((Layout)new FillLayout());
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(1, false));
            Label lblToplevel = new Label(container, 0);
            lblToplevel.setText("Top level process usage");
            this.btnOutdateTop = new Button(container, 32);
            this.btnOutdateTop.setText("Outdate template for top level scope.");
            this.btnOutdateTop.setSelection(OutdateTemplateWizard.this.proxy.isOutdated(false));
            this.btnOutdateTop.addSelectionListener((SelectionListener)this);
            this.btnUninstTop = new Button(container, 32);
            this.btnUninstTop.setText("Set template to uninstantiable for top level scope.");
            this.btnUninstTop.setSelection(!OutdateTemplateWizard.this.proxy.isInstantiable(false));
            this.btnUninstTop.addSelectionListener((SelectionListener)this);
            Label lblSublevel = new Label(container, 0);
            lblSublevel.setText("Sub process usage");
            this.btnOutdateSub = new Button(container, 32);
            this.btnOutdateSub.setText("Outdate template for subprocess scope.");
            this.btnOutdateSub.setSelection(OutdateTemplateWizard.this.proxy.isOutdated(true));
            this.btnOutdateSub.addSelectionListener((SelectionListener)this);
            this.btnUninstSub = new Button(container, 32);
            this.btnUninstSub.setText("Set template to uninstantiable for subprocess scope.");
            this.btnUninstSub.setSelection(!OutdateTemplateWizard.this.proxy.isInstantiable(true));
            this.btnUninstSub.addSelectionListener((SelectionListener)this);
            Label lbl = new Label(container, 0);
            lbl.setText("Comment:");
            this.txtComment = new Text(container, 2048);
            this.txtComment.setLayoutData((Object)new GridData(4, 1, false, false));
            this.widgetSelected(null);
            this.setControl((Control)container);
        }

        public void widgetSelected(SelectionEvent e) {
            this.setMessage(null);
            if (this.btnOutdateTop.getSelection() != this.btnUninstTop.getSelection()) {
                this.setMessage("The process will be outdated but still instantiable", 2);
            }
            if (this.btnOutdateSub.getSelection() != this.btnUninstSub.getSelection()) {
                this.setMessage("The process will be outdated but still instantiable", 2);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

