/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser.wizards;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.processrepository.ProcessRepository;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.ui.processrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogue;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueProvider;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueRegistry;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.LockException;
import java.net.URI;
import java.util.HashSet;
import java.util.UUID;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ReleaseTemplateWizard
extends Wizard {
    protected final TemplateProxy proxy;
    final ProcessRepository repository;
    private ReleaseTemplateWizardPage page;
    private final ProcessManager processManager;

    public ReleaseTemplateWizard(ProcessRepository repository, ProcessManager processManager, TemplateProxy proxy) {
        this.repository = repository;
        this.processManager = processManager;
        this.proxy = proxy;
        this.setWindowTitle("Release template " + proxy.getName());
    }

    public void addPages() {
        super.addPages();
        this.page = new ReleaseTemplateWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        String message;
        UUID id = this.proxy.getID();
        try {
            SessionToken session = this.getToken();
            this.repository.getTemplateManager().release(this.getToken(), id);
            TemplateStatus status = this.repository.getTemplateManager().getAndLockTemplateStatus(session, id);
            try {
                boolean useAsTopLevel = this.page.btnTopLevel.getSelection();
                status.setTopLevelUsage(useAsTopLevel);
                ProcessConstants.TemplateUsage usage = ProcessConstants.TemplateUsage.values()[this.page.cmbSubProcessUsage.getSelectionIndex()];
                status.setSubprocessUsage(usage);
                status.setStarterRule(this.page.txtStarterRule.getText());
                boolean instantiable = this.page.btnInstantiable.getSelection();
                String topLovelComment = this.page.txtTopLevelComment.getText();
                if (useAsTopLevel) {
                    status.setInstantiable(instantiable, false, topLovelComment);
                }
                if (usage != ProcessConstants.TemplateUsage.NO_SUBPROCESS) {
                    status.setInstantiable(instantiable, true, topLovelComment);
                }
                status.setDerivable(true, "Initial derivable state");
                this.repository.getTemplateManager().setTemplateStatus(session, status);
            }
            finally {
                this.repository.getTemplateManager().unlockTemplateStatus(session, id);
            }
        }
        catch (InvalidTemplateStateException e) {
            String message2 = "InvalidTemplateStateException while uploading template status!";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message2, (Throwable)e);
            return false;
        }
        catch (LockException e) {
            String message3 = "LockException while uploading template status!";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message3, (Throwable)e);
            return false;
        }
        if (this.page.btnDeploy.getSelection()) {
            try {
                HashSet<URI[]> processManagerURIs = new HashSet<URI[]>(1);
                processManagerURIs.add(this.processManager.getURIs());
                if (this.page.btnDeploy.getSelection()) {
                    this.repository.getTemplateManager().deployProcessTemplate(this.getToken(), id, processManagerURIs);
                }
            }
            catch (InvalidTemplateStateException e) {
                message = "InvalidTemplateStateException while deploying the template, releasing the template may have failed!";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
            }
            catch (LockException e) {
                message = "LockException while deploying the template, you will need to deploy it later!";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
            }
        }
        if (this.page.chkOutdateParent.getSelection() && this.proxy.getParentTemplateID() != null) {
            try {
                UUID parentID = this.proxy.getParentTemplateID();
                SessionToken session = this.getToken();
                TemplateStatus status = this.repository.getTemplateManager().getAndLockTemplateStatus(session, parentID);
                try {
                    String comment = this.page.txtParentComment.getText();
                    status.setInstantiable(!this.page.btnUninst.getSelection(), false, comment);
                    status.setInstantiable(!this.page.btnUninst.getSelection(), true, comment);
                    status.setOutdated(this.page.btnOutdate.getSelection(), true, comment);
                    status.setOutdated(this.page.btnOutdate.getSelection(), false, comment);
                    this.repository.getTemplateManager().setTemplateStatus(session, status);
                }
                finally {
                    this.repository.getTemplateManager().unlockTemplateStatus(session, id);
                }
            }
            catch (InvalidTemplateStateException e) {
                message = "InvalidTemplateStateException while uploading template status of parent!";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
            }
            catch (LockException e) {
                message = "LockException while uploading template status of parent!";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
            }
        }
        return true;
    }

    SessionToken getToken() {
        return Activator.getService().getSessionToken();
    }

    protected class ReleaseTemplateWizardPage
    extends WizardPage
    implements SelectionListener {
        protected Button btnTopLevel;
        protected Combo cmbSubProcessUsage;
        protected Button btnInstantiable;
        protected Button btnDeploy;
        protected Button chkOutdateParent;
        protected Group grpOutDated;
        protected Button btnOutdate;
        protected Button btnUninst;
        protected Text txtParentComment;
        protected Text txtTopLevelComment;
        protected Text txtStarterRule;

        protected ReleaseTemplateWizardPage() {
            super("Release template " + ReleaseTemplateWizard.this.proxy.getName(), "Release template " + ReleaseTemplateWizard.this.proxy.getName(), null);
            this.setDescription("Specify release settings");
        }

        public void createControl(Composite parent) {
            boolean hasParent;
            parent.setLayout((Layout)new FillLayout());
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(1, false));
            Label lblDescription = new Label(container, 0);
            lblDescription.setText(String.format("You are going to release the template '%s'", ReleaseTemplateWizard.this.proxy.getName()));
            GridData gridData = new GridData(4, 0x1000000, true, false);
            lblDescription.setLayoutData((Object)gridData);
            this.btnTopLevel = new Button(container, 32);
            this.btnTopLevel.setSelection(true);
            this.btnTopLevel.setText("Make the template usable as top-level process.");
            Label lbl = new Label(container, 0);
            lbl.setText("Comment:");
            this.txtTopLevelComment = new Text(container, 2048);
            this.txtTopLevelComment.setLayoutData((Object)new GridData(4, 1, false, false));
            Composite cmpSubProc = new Composite(container, 0);
            cmpSubProc.setLayout((Layout)new GridLayout(2, false));
            Label lblSubProc = new Label(cmpSubProc, 0);
            lblSubProc.setText("Select the usage as sub-process: ");
            gridData = new GridData(4, 0x1000000, true, false);
            lblSubProc.setLayoutData((Object)gridData);
            this.cmbSubProcessUsage = new Combo(cmpSubProc, 8);
            String[] usage = new String[ProcessConstants.TemplateUsage.values().length];
            int i = 0;
            while (i < usage.length) {
                usage[i] = ProcessConstants.TemplateUsage.values()[i].toString();
                ++i;
            }
            this.cmbSubProcessUsage.setItems(usage);
            this.cmbSubProcessUsage.select(0);
            this.btnInstantiable = new Button(container, 32);
            this.btnInstantiable.setText("Make the template instantiable in above scopes");
            gridData = new GridData(4, 0x1000000, true, false);
            this.btnInstantiable.setLayoutData((Object)gridData);
            this.btnInstantiable.setSelection(true);
            Composite starterRuleContainer = new Composite(container, 0);
            starterRuleContainer.setLayout((Layout)new GridLayout(3, false));
            gridData = new GridData(4, 4, true, false);
            starterRuleContainer.setLayoutData((Object)gridData);
            Label lblStarterRule = new Label(starterRuleContainer, 0);
            gridData = new GridData(4, 0x1000000, false, false);
            lblStarterRule.setLayoutData((Object)gridData);
            lblStarterRule.setText("Starter Rule");
            this.txtStarterRule = new Text(starterRuleContainer, 2048);
            gridData = new GridData(4, 4, true, false);
            this.txtStarterRule.setLayoutData((Object)gridData);
            this.txtStarterRule.setText("Agent(username='supervisor')");
            boolean bl = hasParent = ReleaseTemplateWizard.this.proxy.getParentTemplateID() != null;
            if (hasParent) {
                UUID parentID = ReleaseTemplateWizard.this.proxy.getParentTemplateID();
                TemplateStatus parentStatus = ReleaseTemplateWizard.this.repository.getTemplateManager().getTemplateStatus(ReleaseTemplateWizard.this.getToken(), parentID);
                this.txtStarterRule.setText(parentStatus.getStarterRule());
                this.cmbSubProcessUsage.select(parentStatus.getUsageAsSubprocess().ordinal());
            }
            final Button btnStarterRule = new Button(starterRuleContainer, 8);
            gridData = new GridData(4, 4, false, false);
            btnStarterRule.setLayoutData((Object)gridData);
            btnStarterRule.setText("...");
            final StaffAssignmentRuleDialogueProvider[] providers = StaffAssignmentRuleDialogueRegistry.getProviders();
            if (providers.length == 0) {
                btnStarterRule.setEnabled(false);
            }
            btnStarterRule.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OrgModelManager orgModelManager = Activator.getService().getOrgModelManager();
                    StaffAssignmentRuleDialogue dialogue = providers[0].createDialogue(btnStarterRule.getShell(), orgModelManager);
                    if (dialogue.open(ReleaseTemplateWizardPage.this.txtStarterRule.getText())) {
                        ReleaseTemplateWizardPage.this.txtStarterRule.setText(dialogue.getStaffAssignmentRule());
                    }
                }
            });
            this.btnDeploy = new Button(container, 32);
            this.btnDeploy.setText("Deploy the template for execution");
            this.btnDeploy.setSelection(true);
            this.chkOutdateParent = new Button(container, 32);
            this.chkOutdateParent.setSelection(hasParent);
            this.chkOutdateParent.setEnabled(hasParent);
            this.chkOutdateParent.addSelectionListener((SelectionListener)this);
            this.chkOutdateParent.setText("Do you also want to outdate the parent template?");
            this.grpOutDated = new Group(container, 32);
            this.grpOutDated.setLayout((Layout)new GridLayout(1, false));
            this.grpOutDated.setText("Options for the parent template.");
            this.grpOutDated.setLayoutData((Object)new GridData(4, 1, false, false));
            this.grpOutDated.setEnabled(hasParent);
            this.btnOutdate = new Button((Composite)this.grpOutDated, 32);
            this.btnOutdate.setText("Outdate template for top level and subprocess scope.");
            this.btnOutdate.setSelection(hasParent);
            this.btnOutdate.setEnabled(hasParent);
            this.btnUninst = new Button((Composite)this.grpOutDated, 32);
            this.btnUninst.setText("Set template to uninstantiable for top level and subprocess scope.");
            this.btnUninst.setSelection(hasParent);
            this.btnUninst.setEnabled(hasParent);
            lbl = new Label((Composite)this.grpOutDated, 0);
            lbl.setText("Comment:");
            this.txtParentComment = new Text((Composite)this.grpOutDated, 2048);
            this.txtParentComment.setLayoutData((Object)new GridData(4, 1, false, false));
            this.setControl((Control)container);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.chkOutdateParent) {
                boolean enabled = this.chkOutdateParent.getSelection();
                this.grpOutDated.setEnabled(enabled);
                this.btnOutdate.setEnabled(enabled);
                this.btnUninst.setEnabled(enabled);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

