/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.activityrepositorybrowser.actions;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.core.activityrepository.RevisionManager;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.ui.activityrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.activityrepositorybrowser.views.RepositoryBrowser;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SetWorkingRevisionBranchAction
extends Action {
    private final RepositoryBrowser controller;

    public SetWorkingRevisionBranchAction(RepositoryBrowser controller) {
        super("Select Revision/Branch", Activator.getImageDescriptor("icons/repository.gif"));
        this.controller = controller;
    }

    public void run() {
        RevisionBranchWizard wizard = new RevisionBranchWizard();
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.create();
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            if (wizard.getRevision() != null) {
                this.controller.setWorkingRevision(wizard.getRevision());
            } else {
                this.controller.setWorkingBranch(wizard.getBranch());
            }
        }
    }

    private class RevisionBranchPage
    extends WizardPage
    implements SelectionListener,
    ModifyListener {
        private Button radioSelectRevision;
        private Button radioSelectBranch;
        private Combo comboBranch;
        private Text textRevision;
        private Button checkRevisionLatest;
        private List<Branch> branchValues;
        private boolean branchAvailable;
        private long maxRevision;
        private Label lblBranchComment;

        protected RevisionBranchPage(String pageName) {
            super(pageName);
            this.setTitle("Select revision/branch");
            this.setDescription("Specify the revision/branch to work on");
        }

        public void createControl(Composite parent) {
            Composite client = new Composite(parent, 0);
            GridLayout clientLayout = new GridLayout();
            clientLayout.numColumns = 3;
            client.setLayout((Layout)clientLayout);
            ActivityRepository repository = Activator.getService().getActivityRepository();
            SessionToken session = Activator.getService().getSessionToken();
            this.maxRevision = repository.getRevisionManager().getLatestRevision(session).getRevision();
            this.radioSelectRevision = new Button(client, 16);
            this.radioSelectRevision.setLayoutData((Object)new GridData(1, 1, false, false, 3, 1));
            this.radioSelectRevision.addSelectionListener((SelectionListener)this);
            this.radioSelectRevision.setText("Select revision (read only mode)");
            Label lblRevision = new Label(client, 0);
            lblRevision.setText("Revision:");
            this.checkRevisionLatest = new Button(client, 32);
            this.checkRevisionLatest.setText("latest");
            this.checkRevisionLatest.addSelectionListener((SelectionListener)this);
            this.textRevision = new Text(client, 2048);
            this.textRevision.setLayoutData((Object)new GridData(4, 1, true, false));
            this.textRevision.setText(Long.toString(this.maxRevision));
            this.textRevision.addModifyListener((ModifyListener)this);
            this.radioSelectBranch = new Button(client, 16);
            this.radioSelectBranch.setLayoutData((Object)new GridData(1, 1, false, false, 3, 1));
            this.radioSelectBranch.addSelectionListener((SelectionListener)this);
            this.radioSelectBranch.setText("Select branch (writeable)");
            Label lblBranch = new Label(client, 0);
            lblBranch.setText("Branch:");
            this.comboBranch = new Combo(client, 12);
            this.comboBranch.select(0);
            this.comboBranch.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.branchAvailable = false;
            this.branchValues = new ArrayList<Branch>();
            for (Branch branch : repository.getRevisionManager().getAllBranches(session)) {
                this.branchAvailable = true;
                String s = String.format("Branch %s (Base Revision %s), %s, %s", branch.getBranch(), branch.getBaseRevision().getRevision(), branch.getCreationAgent().getAgentUserName(), this.getDateString(branch.getCreationTime()));
                this.comboBranch.add(s);
                this.branchValues.add(branch);
            }
            this.comboBranch.select(0);
            if (!this.branchAvailable) {
                this.radioSelectBranch.setEnabled(false);
            } else {
                new Label(client, 0);
                this.lblBranchComment = new Label(client, 64);
                this.lblBranchComment.setLayoutData((Object)new GridData(4, 4, false, false));
                this.refreshBranchComment();
                this.comboBranch.addSelectionListener((SelectionListener)this);
            }
            this.radioSelectRevision.setSelection(true);
            this.checkRevisionLatest.setSelection(true);
            this.textRevision.setEnabled(false);
            this.comboBranch.setEnabled(false);
            this.setControl((Control)client);
            this.showData();
        }

        private void showData() {
            if (SetWorkingRevisionBranchAction.this.controller.getWorkingRevision() != null) {
                this.radioSelectRevision.setSelection(true);
                this.checkRevisionLatest.setEnabled(true);
                this.radioSelectBranch.setSelection(false);
                this.comboBranch.setEnabled(false);
                this.textRevision.setText(Long.toString(SetWorkingRevisionBranchAction.this.controller.getWorkingRevision()));
                RevisionManager revMan = Activator.getService().getActivityRepository().getRevisionManager();
                SessionToken session = Activator.getService().getSessionToken();
                if (revMan.getLatestRevision(session).getRevision() == SetWorkingRevisionBranchAction.this.controller.getWorkingRevision().longValue()) {
                    this.checkRevisionLatest.setSelection(true);
                    this.textRevision.setEnabled(false);
                } else {
                    this.checkRevisionLatest.setSelection(false);
                    this.textRevision.setEnabled(true);
                }
            } else if (this.branchAvailable) {
                this.radioSelectRevision.setSelection(false);
                this.checkRevisionLatest.setEnabled(false);
                this.textRevision.setEnabled(false);
                this.radioSelectBranch.setSelection(true);
                this.comboBranch.setEnabled(true);
                int i = 0;
                while (i < this.branchValues.size()) {
                    if (this.branchValues.get(i).getBranch() == SetWorkingRevisionBranchAction.this.controller.getWorkingBranch().longValue()) {
                        this.comboBranch.select(i);
                        break;
                    }
                    ++i;
                }
            }
        }

        private String getDateString(long date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 3, Activator.getService().getActiveAgent().getLocale());
            return date <= 0L ? "Not set" : formatter.format(new Date(date));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.radioSelectBranch) {
                this.textRevision.setEnabled(false);
                this.checkRevisionLatest.setEnabled(false);
                this.comboBranch.setEnabled(true);
            }
            if (e.widget == this.radioSelectRevision) {
                this.textRevision.setEnabled(!this.checkRevisionLatest.getSelection());
                this.checkRevisionLatest.setEnabled(true);
                this.comboBranch.setEnabled(false);
            }
            if (e.widget == this.checkRevisionLatest) {
                this.textRevision.setEnabled(!this.checkRevisionLatest.getSelection());
            }
            if (e.widget == this.comboBranch) {
                this.refreshBranchComment();
            }
        }

        private void refreshBranchComment() {
            String comment = this.branchValues.get(this.comboBranch.getSelectionIndex()).getComment();
            this.lblBranchComment.setText(comment);
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == this.textRevision) {
                try {
                    long revision = Long.parseLong(this.textRevision.getText());
                    if (revision > this.maxRevision || revision < 0L) {
                        String s = String.format("The specified revision does not exist! Maximum revision is %s.", this.maxRevision);
                        this.setErrorMessage(s);
                    } else {
                        this.setErrorMessage(null);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage("Revision needs to be a number");
                }
            }
        }

        public boolean canFlipToNextPage() {
            return this.getErrorMessage() == null;
        }

        public void setErrorMessage(String newMessage) {
            super.setErrorMessage(newMessage);
            this.getContainer().updateButtons();
        }

        public Long getRevision() {
            if (this.radioSelectRevision.getSelection()) {
                if (this.checkRevisionLatest.getSelection()) {
                    return this.maxRevision;
                }
                return Long.parseLong(this.textRevision.getText());
            }
            return null;
        }

        public Long getBranch() {
            if (this.radioSelectBranch.getSelection()) {
                return this.branchValues.get(this.comboBranch.getSelectionIndex()).getBranch();
            }
            return null;
        }
    }

    private class RevisionBranchWizard
    extends Wizard {
        private RevisionBranchPage page;
        private Long revision;
        private Long branch;

        private RevisionBranchWizard() {
        }

        public boolean performFinish() {
            this.revision = this.page.getRevision();
            this.branch = this.page.getBranch();
            return true;
        }

        public void addPages() {
            this.page = new RevisionBranchPage("RevisionBranch");
            this.addPage((IWizardPage)this.page);
        }

        public void createPageControls(Composite pageContainer) {
            super.createPageControls(pageContainer);
            this.setWindowTitle("Activity Repository");
        }

        public boolean performCancel() {
            return true;
        }

        public boolean canFinish() {
            return this.page.canFlipToNextPage();
        }

        public Long getRevision() {
            return this.revision;
        }

        public Long getBranch() {
            return this.branch;
        }
    }
}

