/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.activityrepositorybrowser.browsers;

import de.aristaflow.adept2.ui.activityrepositorybrowser.browsers.ActivityRepositoryBrowser;
import de.aristaflow.adept2.ui.activityrepositorybrowser.views.RepositoryBrowser;
import de.aristaflow.adept2.ui.util.list.ListUIComponent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class AbstractTreeActivityRepositoryBrowser
implements ActivityRepositoryBrowser,
IDoubleClickListener {
    protected RepositoryBrowser controller;
    protected ListUIComponent treeWidget;
    protected IWorkbenchPartSite site;
    private Composite container;

    protected abstract boolean needDragSupport();

    protected abstract ListUIComponent getListUIComponent(Composite var1);

    protected abstract String getPopupMenuID();

    @Override
    public void setController(RepositoryBrowser controller) {
        this.controller = controller;
    }

    public void dragFinished(DragSourceEvent event) {
    }

    public void dragSetData(DragSourceEvent event) {
        IStructuredSelection sel = (IStructuredSelection)this.treeWidget.getColumnViewer().getSelection();
        event.data = this.controller.getDragData(sel.getFirstElement());
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection sel = (IStructuredSelection)this.treeWidget.getColumnViewer().getSelection();
        event.doit = this.controller.grantDragStart(sel);
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection sel = (IStructuredSelection)this.treeWidget.getColumnViewer().getSelection();
        this.controller.openItem(sel.getFirstElement());
    }

    @Override
    public void createPartControl(Composite parent, IWorkbenchPartSite partSite) {
        this.site = partSite;
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new FillLayout());
        this.treeWidget = this.getListUIComponent(this.container);
        if (this.needDragSupport()) {
            this.treeWidget.getColumnViewer().addDragSupport(this.controller.getDragOperations(), this.controller.getTransferTypes(), (DragSourceListener)this);
        }
        this.treeWidget.getColumnViewer().addDoubleClickListener((IDoubleClickListener)this);
        if (this.getPopupMenuID() != null) {
            partSite.registerContextMenu(this.getPopupMenuID(), this.treeWidget.getContextMenu(), (ISelectionProvider)this.treeWidget.getColumnViewer());
        }
    }

    @Override
    public void refresh() {
        this.treeWidget.getColumnViewer().refresh();
        this.treeWidget.getColumnControl().layout();
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.treeWidget.getColumnViewer();
    }

    @Override
    public void setFocus() {
        this.treeWidget.setFocus();
    }

    @Override
    public Control getTopMostControl() {
        return this.container;
    }
}

