/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.activityrepositorybrowser.browsers;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.ui.activityrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.activityrepositorybrowser.browsers.AbstractTreeActivityRepositoryBrowser;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.list.ListUIComponent;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class IdentifierActivityRepositoryBrowser
extends AbstractTreeActivityRepositoryBrowser {
    public static final String popupMenuID = String.valueOf(Activator.getPluginID()) + ".browsers.identifiers.popupmenu";
    public static final String popupGroupCreate = "create";
    public static final String popupGroupRemove = "remove";
    public static final String popupGroupImportExport = "importExport";
    public static final String popupGroupAdditional = "additional";

    @Override
    protected ListUIComponent getListUIComponent(Composite parent) {
        return new IdentifierActivityBrowserList(parent);
    }

    @Override
    protected boolean needDragSupport() {
        return false;
    }

    @Override
    protected String getPopupMenuID() {
        return popupMenuID;
    }

    @Override
    public Collection<? extends Class> getControlledObjects() {
        ArrayList<Class<Identifier>> res = new ArrayList<Class<Identifier>>();
        res.add(Identifier.class);
        return res;
    }

    @Override
    public String getTitle() {
        return "Identifier";
    }

    @Override
    public void refresh() {
        ((IdentifierActivityBrowserList)this.treeWidget.getColumnViewer().getContentProvider()).clearCache();
        super.refresh();
    }

    private class IdentifierActivityBrowserList
    extends ListUIComponent
    implements ITreeContentProvider {
        private static final String COL_NAME = "colName";
        private ActivityRepository repository;
        private final String rootNode = "Identifier Repository";
        private Collection<Identifier> cachedIdentifiers;

        public IdentifierActivityBrowserList(Composite parent) {
            super(Tree.class, parent, 0);
            this.rootNode = "Identifier Repository";
            this.cachedIdentifiers = new ArrayList<Identifier>();
            this.repository = Activator.getService().getActivityRepository();
            this.initColumns(new String[]{COL_NAME}, null, COL_NAME, true);
            ((TreeViewer)this.getColumnViewer()).setAutoExpandLevel(2);
            this.getColumnViewer().setContentProvider((IContentProvider)this);
            this.setInput("");
        }

        protected void registerColumns() {
            super.registerColumns();
            this.registerColumn(COL_NAME, "Name", 16384, new ColumnData(1.0f), (CellLabelProvider)new ColumnLabelProvider(){

                public Image getImage(Object element) {
                    Image image;
                    String imageName = null;
                    imageName = element instanceof Identifier ? "icons/activity_template_definition.gif" : "icons/repository.gif";
                    ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
                    if (this.isOutdated(element)) {
                        String outdatedImageName = String.valueOf(imageName) + "_outdated";
                        image = imageRegistry.get(outdatedImageName);
                        if (image == null) {
                            Image normalImage = Activator.getDefault().getImage(imageName);
                            image = new Image((Device)IdentifierActivityBrowserList.this.getControl().getDisplay(), normalImage, 2);
                            imageRegistry.put(outdatedImageName, image);
                        }
                    } else if (this.isDirty(element)) {
                        String dirtyImageName = String.valueOf(imageName) + "_dirty";
                        image = imageRegistry.get(dirtyImageName);
                        if (image == null) {
                            Image normalImage = Activator.getDefault().getImage(imageName);
                            ImageDescriptor overlayDescriptor = Activator.getImageDescriptor("icons/dirty_overlay.gif");
                            DecorationOverlayIcon desc = new DecorationOverlayIcon(normalImage, overlayDescriptor, 3);
                            image = desc.createImage();
                            imageRegistry.put(dirtyImageName, image);
                        }
                    } else {
                        image = Activator.getDefault().getImage(imageName);
                    }
                    return image;
                }

                public String getText(Object element) {
                    if (element instanceof String) {
                        return (String)element;
                    }
                    if (element instanceof Identifier) {
                        return ((Identifier)element).getName();
                    }
                    return "";
                }

                private boolean isOutdated(Object o) {
                    if (o instanceof Identifier) {
                        return ((Identifier)o).getState() == State.OUTDATED;
                    }
                    return false;
                }

                private boolean isDirty(Object o) {
                    if (o instanceof Identifier) {
                        return ((Identifier)o).getState() == State.IN_DEVELOPMENT;
                    }
                    return false;
                }
            }, null);
        }

        public synchronized Object[] getChildren(Object parentElement) {
            SessionToken session = Activator.getService().getSessionToken();
            if (parentElement instanceof String) {
                if (this.cachedIdentifiers.size() == 0) {
                    this.cachedIdentifiers = IdentifierActivityRepositoryBrowser.this.controller.getWorkingBranch() != null ? this.repository.getIdentifierManager().getDevelopmentIdentifiers(session, IdentifierActivityRepositoryBrowser.this.controller.getWorkingBranch().longValue()) : this.repository.getIdentifierManager().getIdentifiersRevision(session, IdentifierActivityRepositoryBrowser.this.controller.getWorkingRevision().longValue());
                }
                return this.cachedIdentifiers.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof Identifier) {
                return "Identifier Repository";
            }
            return null;
        }

        public synchronized boolean hasChildren(Object element) {
            if (element instanceof String) {
                if (this.cachedIdentifiers.size() == 0) {
                    SessionToken session = Activator.getService().getSessionToken();
                    this.cachedIdentifiers = IdentifierActivityRepositoryBrowser.this.controller.getWorkingBranch() != null ? this.repository.getIdentifierManager().getDevelopmentIdentifiers(session, IdentifierActivityRepositoryBrowser.this.controller.getWorkingBranch().longValue()) : this.repository.getIdentifierManager().getIdentifiersRevision(session, IdentifierActivityRepositoryBrowser.this.controller.getWorkingRevision().longValue());
                }
                return this.cachedIdentifiers.size() > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{"Identifier Repository"};
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        protected void fillContextMenu(MenuManager contextMenuToFill) {
            contextMenuToFill.add((IContributionItem)new Separator("additions"));
            contextMenuToFill.add((IContributionItem)new Separator(IdentifierActivityRepositoryBrowser.popupGroupCreate));
            contextMenuToFill.add((IContributionItem)new Separator(IdentifierActivityRepositoryBrowser.popupGroupRemove));
            contextMenuToFill.add((IContributionItem)new Separator(IdentifierActivityRepositoryBrowser.popupGroupImportExport));
            contextMenuToFill.add((IContributionItem)new Separator(IdentifierActivityRepositoryBrowser.popupGroupAdditional));
        }

        public void dispose() {
        }

        public synchronized void clearCache() {
            this.cachedIdentifiers.clear();
        }
    }
}

