/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.activityrepositorybrowser.browsers;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.activitymodel.ECDReference;
import de.aristaflow.adept2.model.activitymodel.OperationReference;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.ui.activityrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.activityrepositorybrowser.browsers.AbstractTreeActivityRepositoryBrowser;
import de.aristaflow.adept2.ui.util.FontTools;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.list.ListUIComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class MainActivityRepositoryBrowser
extends AbstractTreeActivityRepositoryBrowser {
    public static final String popupMenuID = String.valueOf(Activator.getPluginID()) + ".browsers.main.popupmenu";
    public static final String popupGroupCreate = "create";
    public static final String popupGroupRemove = "remove";
    public static final String popupGroupECImportExport = "ecImportExport";
    public static final String popupGroupOtherImportExport = "otherImportExport";
    public static final String popupGroupAdditional = "additional";

    @Override
    protected ListUIComponent getListUIComponent(Composite parent) {
        return new MainARBrowserList(parent);
    }

    @Override
    protected boolean needDragSupport() {
        return true;
    }

    @Override
    public void refresh() {
        ((MainARBrowserList)this.treeWidget.getColumnViewer().getContentProvider()).clearCache();
        super.refresh();
    }

    @Override
    protected String getPopupMenuID() {
        return popupMenuID;
    }

    @Override
    public Collection<? extends Class> getControlledObjects() {
        ArrayList<Class<ATDReference>> res = new ArrayList<Class<ATDReference>>();
        res.add(ECDReference.class);
        res.add(OperationReference.class);
        res.add(ATDReference.class);
        return res;
    }

    @Override
    public String getTitle() {
        return "Main";
    }

    protected class MainARBrowserList
    extends ListUIComponent
    implements ITreeContentProvider {
        private static final String COL_NAME = "colName";
        private ActivityRepository repository;
        private final String rootNode = "Activity Repository";
        private Map<String, ECDReference> cachedECDs;
        private Map<String, Map<String, OperationReference>> cachedOperations;
        private Map<String, Map<String, Map<String, ATDReference>>> cachedATDs;

        public MainARBrowserList(Composite parent) {
            super(Tree.class, parent, 0);
            this.rootNode = "Activity Repository";
            this.repository = Activator.getService().getActivityRepository();
            this.cachedATDs = new HashMap<String, Map<String, Map<String, ATDReference>>>();
            this.cachedECDs = new HashMap<String, ECDReference>();
            this.cachedOperations = new HashMap<String, Map<String, OperationReference>>();
            this.initColumns(new String[]{COL_NAME}, null, COL_NAME, true);
            ((TreeViewer)this.getColumnViewer()).setAutoExpandLevel(2);
            ((TreeViewer)this.getColumnViewer()).addTreeListener(new ITreeViewerListener(){

                public void treeCollapsed(TreeExpansionEvent event) {
                    MainARBrowserList.this.getColumnControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MainARBrowserList.this.getColumnControl().layout();
                        }
                    });
                }

                public void treeExpanded(TreeExpansionEvent event) {
                    MainARBrowserList.this.getColumnControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MainARBrowserList.this.getColumnControl().layout();
                        }
                    });
                }
            });
            this.getColumnViewer().setContentProvider((IContentProvider)this);
            this.setInput("");
        }

        protected void registerColumns() {
            super.registerColumns();
            this.registerColumn(COL_NAME, "Name", 16384, new ColumnData(1.0f), (CellLabelProvider)new ColumnLabelProvider(){

                public Image getImage(Object element) {
                    Image image;
                    String imageName = null;
                    imageName = element instanceof ECDReference ? "icons/component_production.gif" : (element instanceof OperationReference ? "icons/operation.gif" : (element instanceof ATDReference ? "icons/activity_template_definition.gif" : "icons/repository.gif"));
                    ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
                    if (this.isOutdated(element)) {
                        String outdatedImageName = String.valueOf(imageName) + "_outdated";
                        image = imageRegistry.get(outdatedImageName);
                        if (image == null) {
                            Image normalImage = Activator.getDefault().getImage(imageName);
                            image = new Image((Device)MainARBrowserList.this.getControl().getDisplay(), normalImage, 2);
                            imageRegistry.put(outdatedImageName, image);
                        }
                    } else if (this.isDirty(element)) {
                        String dirtyImageName = String.valueOf(imageName) + "_dirty";
                        image = imageRegistry.get(dirtyImageName);
                        if (image == null) {
                            Image normalImage = Activator.getDefault().getImage(imageName);
                            ImageDescriptor overlayDescriptor = Activator.getImageDescriptor("icons/dirty_overlay.gif");
                            DecorationOverlayIcon desc = new DecorationOverlayIcon(normalImage, overlayDescriptor, 3);
                            image = desc.createImage();
                            imageRegistry.put(dirtyImageName, image);
                        }
                    } else {
                        image = Activator.getDefault().getImage(imageName);
                    }
                    return image;
                }

                public String getText(Object element) {
                    if (element instanceof ECDReference) {
                        return ((ECDReference)element).getName();
                    }
                    if (element instanceof OperationReference) {
                        return ((OperationReference)element).getName();
                    }
                    if (element instanceof ATDReference) {
                        return ((ATDReference)element).getName();
                    }
                    if (element instanceof String) {
                        return (String)element;
                    }
                    return "";
                }

                public Font getFont(Object element) {
                    Font font = super.getFont(element);
                    if (this.isOutdated(element)) {
                        if (font == null) {
                            font = MainARBrowserList.this.getControl().getDisplay().getSystemFont();
                        }
                        return FontTools.deriveFontStyle((Font)font, (int)2);
                    }
                    return font;
                }

                public Color getForeground(Object element) {
                    if (this.isOutdated(element)) {
                        return new Color(null, 64, 64, 64);
                    }
                    return super.getForeground(element);
                }

                private boolean isOutdated(Object element) {
                    if (element instanceof ECDReference) {
                        return ((ECDReference)element).getState() == State.OUTDATED;
                    }
                    if (element instanceof OperationReference) {
                        return ((OperationReference)element).getState() == State.OUTDATED;
                    }
                    if (element instanceof ATDReference) {
                        return ((ATDReference)element).getState() == State.OUTDATED;
                    }
                    return false;
                }

                private boolean isDirty(Object element) {
                    if (element instanceof ECDReference) {
                        return ((ECDReference)element).getState() == State.IN_DEVELOPMENT;
                    }
                    if (element instanceof OperationReference) {
                        return ((OperationReference)element).getState() == State.IN_DEVELOPMENT;
                    }
                    if (element instanceof ATDReference) {
                        return ((ATDReference)element).getState() == State.IN_DEVELOPMENT;
                    }
                    return false;
                }
            }, null);
        }

        public Object[] getChildren(Object parentElement) {
            SessionToken session = Activator.getService().getSessionToken();
            if (parentElement instanceof String) {
                Collection ecds = MainActivityRepositoryBrowser.this.controller.getWorkingBranch() != null ? this.repository.getECDManager().getDevelopmentECDReferences(session, MainActivityRepositoryBrowser.this.controller.getWorkingBranch().longValue()) : this.repository.getECDManager().getECDReferencesRevision(session, MainActivityRepositoryBrowser.this.controller.getWorkingRevision().longValue());
                this.cacheECDs(ecds);
                return ecds.toArray();
            }
            if (parentElement instanceof ECDReference) {
                String ecName = ((ECDReference)parentElement).getName();
                Collection ops = MainActivityRepositoryBrowser.this.controller.getWorkingBranch() != null ? this.repository.getOperationManager().getDevelopmentOperationReferencesOfECD(session, ecName, MainActivityRepositoryBrowser.this.controller.getWorkingBranch().longValue()) : this.repository.getOperationManager().getOperationReferencesRevisionOfECD(session, ecName, MainActivityRepositoryBrowser.this.controller.getWorkingRevision().longValue());
                this.cacheOperations(ecName, ops);
                return ops.toArray();
            }
            if (parentElement instanceof OperationReference) {
                String ecName = ((OperationReference)parentElement).getExecutableComponentName();
                String operationName = ((OperationReference)parentElement).getName();
                Collection atds = MainActivityRepositoryBrowser.this.controller.getWorkingBranch() != null ? this.repository.getATDManager().getDevelopmentATDReferencesOfOperation(session, ecName, operationName, MainActivityRepositoryBrowser.this.controller.getWorkingBranch().longValue()) : this.repository.getATDManager().getATDReferencesRevisionOfOperation(session, ecName, operationName, MainActivityRepositoryBrowser.this.controller.getWorkingRevision().longValue());
                this.cacheATDs(ecName, operationName, atds);
                return atds.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof String) {
                return null;
            }
            if (element instanceof ECDReference) {
                return "Activity Repository";
            }
            if (element instanceof OperationReference) {
                String ecName = ((OperationReference)element).getExecutableComponentName();
                return this.cachedECDs.get(ecName);
            }
            if (element instanceof ATDReference) {
                String ecName = ((ATDReference)element).getExecutableComponentName();
                String operationName = ((ATDReference)element).getOperationName();
                if (this.cachedOperations.containsKey(ecName)) {
                    return this.cachedOperations.get(ecName).get(operationName);
                }
                return null;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children != null && children.length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{"Activity Repository"};
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.clearCache();
        }

        public void clearCache() {
            this.cachedECDs.clear();
            this.cachedOperations.clear();
            this.cachedATDs.clear();
        }

        private void cacheATDs(String ecName, String operationName, Collection<ATDReference> atds) {
            Map<String, ATDReference> atdMap;
            Map<Object, Object> opMap;
            if (this.cachedATDs.containsKey(ecName)) {
                opMap = this.cachedATDs.get(ecName);
            } else {
                opMap = new HashMap();
                this.cachedATDs.put(ecName, opMap);
            }
            if (opMap.containsKey(operationName)) {
                atdMap = (Map)opMap.get(operationName);
            } else {
                atdMap = new HashMap();
                opMap.put(operationName, atdMap);
            }
            for (ATDReference atd : atds) {
                atdMap.put(atd.getName(), atd);
            }
        }

        private void cacheOperations(String ecName, Collection<OperationReference> ops) {
            Map<Object, Object> opMap;
            if (this.cachedOperations.containsKey(ecName)) {
                opMap = this.cachedOperations.get(ecName);
            } else {
                opMap = new HashMap();
                this.cachedOperations.put(ecName, opMap);
            }
            for (OperationReference op : ops) {
                opMap.put(op.getName(), op);
            }
        }

        private void cacheECDs(Collection<ECDReference> ecds) {
            for (ECDReference ecd : ecds) {
                this.cachedECDs.put(ecd.getName(), ecd);
            }
        }

        protected void fillContextMenu(MenuManager contextMenuToFill) {
            contextMenuToFill.add((IContributionItem)new Separator("additions"));
            contextMenuToFill.add((IContributionItem)new Separator(MainActivityRepositoryBrowser.popupGroupCreate));
            contextMenuToFill.add((IContributionItem)new Separator(MainActivityRepositoryBrowser.popupGroupRemove));
            contextMenuToFill.add((IContributionItem)new Separator(MainActivityRepositoryBrowser.popupGroupECImportExport));
            contextMenuToFill.add((IContributionItem)new Separator(MainActivityRepositoryBrowser.popupGroupOtherImportExport));
            contextMenuToFill.add((IContributionItem)new Separator(MainActivityRepositoryBrowser.popupGroupAdditional));
        }

        public void dispose() {
        }
    }
}

