/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.activityrepositorybrowser.views;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplate;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.xml.ActivityModelXMLExport;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.ui.activityrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.activityrepositorybrowser.actions.RefreshFromRepositoryAction;
import de.aristaflow.adept2.ui.activityrepositorybrowser.actions.SetWorkingRevisionBranchAction;
import de.aristaflow.adept2.ui.activityrepositorybrowser.browsers.ActivityRepositoryBrowser;
import de.aristaflow.adept2.ui.activityrepositorybrowser.extensions.OpenAction;
import de.aristaflow.adept2.ui.activityrepositorybrowser.views.RepositoryBrowser;
import de.aristaflow.adept2.ui.activityrepositorybrowser.views.RevisionBranchSwitchListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class RepositoryBrowserView
extends ViewPart
implements RepositoryBrowser,
ITabbedPropertySheetPageContributor,
ISelectionChangedListener {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".views.RepositoryBrowserView";
    public static final String MEMENTO_CURRENT_TAB = "StoreCurrentTab";
    public static final String MEMENTO_BRANCH = "MementoOfLastSelectedBranch";
    private List<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();
    private ActivityRepository repository;
    private CTabFolder tabFolder;
    private List<OpenAction> openActions = new LinkedList<OpenAction>();
    private IToolBarManager toolbarManager;
    protected final int dragOperations = 3;
    protected final Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
    private IMemento memento;
    private List<ActivityRepositoryBrowser> browsers = new ArrayList<ActivityRepositoryBrowser>();
    private ISelection currentSelection = null;
    private Long revision = null;
    private Long branch = null;
    private Label lblHeader;
    private List<RevisionBranchSwitchListener> revisionBranchSwitchListeners;

    public void init(IViewSite site, IMemento stateMemento) throws PartInitException {
        this.memento = stateMemento;
        super.init(site, stateMemento);
    }

    public void saveState(IMemento stateMemento) {
        super.saveState(stateMemento);
        stateMemento.putInteger(MEMENTO_CURRENT_TAB, this.tabFolder.getSelectionIndex());
        if (this.branch != null) {
            stateMemento.putString(MEMENTO_BRANCH, this.branch.toString());
        }
    }

    public void createPartControl(Composite parent) {
        String branchMemento;
        this.repository = Activator.getService().getActivityRepository();
        SessionToken session = Activator.getService().getSessionToken();
        this.setPartName("Activity Repository Browser");
        GridLayout parentLayout = new GridLayout(1, false);
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parent.setLayout((Layout)parentLayout);
        Composite compositeHeader = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, false, false);
        gridData.horizontalIndent = 5;
        gridData.verticalIndent = 3;
        compositeHeader.setLayoutData((Object)gridData);
        compositeHeader.setLayout((Layout)new FillLayout());
        this.lblHeader = new Label(compositeHeader, 0);
        this.revisionBranchSwitchListeners = new ArrayList<RevisionBranchSwitchListener>();
        boolean branchSelected = false;
        if (this.memento != null && (branchMemento = this.memento.getString(MEMENTO_BRANCH)) != null) {
            try {
                long value = Long.parseLong(branchMemento);
                session = Activator.getService().getSessionToken();
                Collection branches = Activator.getService().getActivityRepository().getRevisionManager().getAllBranches(session);
                for (Branch availableBranch : branches) {
                    if (availableBranch.getBranch() != value) continue;
                    this.setWorkingBranch(value);
                    branchSelected = true;
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!branchSelected) {
            this.setWorkingRevision(this.repository.getRevisionManager().getLatestRevision(session).getRevision());
        }
        this.tabFolder = new CTabFolder(parent, 128);
        this.tabFolder.setSimple(false);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof CTabFolder) {
                    int idx = ((CTabFolder)e.widget).getSelectionIndex();
                    ActivityRepositoryBrowser newBrowser = (ActivityRepositoryBrowser)RepositoryBrowserView.this.browsers.get(idx);
                    newBrowser.refresh();
                    SelectionChangedEvent newEvent = new SelectionChangedEvent(newBrowser.getSelectionProvider(), newBrowser.getSelectionProvider().getSelection());
                    RepositoryBrowserView.this.selectionChanged(newEvent);
                }
            }
        });
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(String.valueOf(Activator.getPluginID()) + ".browsers");
        int n = iConfigurationElementArray.length;
        int value = 0;
        while (value < n) {
            ActivityRepositoryBrowser browser;
            IConfigurationElement configurationElement = iConfigurationElementArray[value];
            try {
                browser = (ActivityRepositoryBrowser)configurationElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                String s = String.format("Could not instantiate class %s.", configurationElement.getAttribute("class"));
                throw new RuntimeException(s, e);
            }
            CTabItem tabItem = new CTabItem(this.tabFolder, 0);
            browser.setController(this);
            browser.createPartControl((Composite)this.tabFolder, this.getSite());
            browser.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
            tabItem.setControl(browser.getTopMostControl());
            tabItem.setText(browser.getTitle());
            this.browsers.add(browser);
            ++value;
        }
        this.toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        RefreshFromRepositoryAction refreshFromRepositoryAction = new RefreshFromRepositoryAction(this);
        this.toolbarManager.add((IAction)refreshFromRepositoryAction);
        this.toolbarManager.add((IAction)new SetWorkingRevisionBranchAction(this));
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)refreshFromRepositoryAction);
        this.getViewSite().getActionBars().updateActionBars();
        IConfigurationElement[] iConfigurationElementArray2 = Platform.getExtensionRegistry().getConfigurationElementsFor(String.valueOf(Activator.getPluginID()) + ".openaction");
        int n2 = iConfigurationElementArray2.length;
        n = 0;
        while (n < n2) {
            IConfigurationElement configurationElement = iConfigurationElementArray2[n];
            OpenAction openAction = null;
            try {
                openAction = (OpenAction)((Object)configurationElement.createExecutableExtension("class"));
            }
            catch (CoreException e) {
                String s = String.format("Could not instantiate class %s", configurationElement.getAttribute("class"));
                throw new RuntimeException(s, e);
            }
            if (openAction != null) {
                this.openActions.add(openAction);
            }
            ++n;
        }
        iConfigurationElementArray2 = Platform.getExtensionRegistry().getConfigurationElementsFor(String.valueOf(Activator.getPluginID()) + ".RevisionBranchSwitchListener");
        n2 = iConfigurationElementArray2.length;
        n = 0;
        while (n < n2) {
            IConfigurationElement configurationElement = iConfigurationElementArray2[n];
            try {
                RevisionBranchSwitchListener listener = (RevisionBranchSwitchListener)configurationElement.createExecutableExtension("class");
                this.revisionBranchSwitchListeners.add(listener);
            }
            catch (CoreException e1) {
                String s = String.format("Could not instantiate class %s", configurationElement.getAttribute("class"));
                throw new RuntimeException(s, e1);
            }
            ++n;
        }
        Integer tabIndex = null;
        if (this.memento != null) {
            tabIndex = this.memento.getInteger(MEMENTO_CURRENT_TAB);
        }
        if (tabIndex != null) {
            this.tabFolder.setSelection(tabIndex.intValue());
        } else {
            this.tabFolder.setSelection(0);
        }
        this.memento = null;
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    public void setFocus() {
        int idx = this.tabFolder.getSelectionIndex();
        if (idx < 0) {
            if (this.browsers.size() == 0) {
                return;
            }
            idx = 0;
        }
        this.browsers.get(idx).setFocus();
    }

    @Override
    public int getDragOperations() {
        return 3;
    }

    @Override
    public Transfer[] getTransferTypes() {
        return this.transferTypes;
    }

    @Override
    public Object getDragData(Object modelObject) {
        SessionToken session = Activator.getService().getSessionToken();
        ActivityModelXMLExport export = new ActivityModelXMLExport();
        String ret = null;
        if (modelObject instanceof ActivityTemplate) {
            ret = export.activityTemplateToString((ActivityTemplate)modelObject);
        } else if (modelObject instanceof ActivityTemplateDefinition || modelObject instanceof ATDReference) {
            ActivityTemplate at = null;
            String ecName = null;
            String operationName = null;
            String atdName = null;
            if (modelObject instanceof ActivityTemplateDefinition) {
                ActivityTemplateDefinition atd = (ActivityTemplateDefinition)modelObject;
                ecName = atd.getOperation().getExecutableComponentDescription().getName();
                operationName = atd.getOperation().getName();
                atdName = atd.getName();
            } else {
                ATDReference ref = (ATDReference)modelObject;
                ecName = ref.getExecutableComponentName();
                operationName = ref.getOperationName();
                atdName = ref.getName();
            }
            at = this.branch != null ? this.repository.getDevelopmentActivityTemplate(session, ecName, operationName, atdName, this.branch.longValue()) : this.repository.getActivityTemplateRevision(session, ecName, operationName, atdName, this.revision.longValue());
            ret = export.activityTemplateToString(at);
        }
        return ret;
    }

    @Override
    public boolean grantDragStart(Object modelObject) {
        if (modelObject instanceof TreeSelection) {
            Object object = ((TreeSelection)modelObject).getFirstElement();
            return object instanceof ActivityTemplateDefinition || object instanceof ATDReference;
        }
        return false;
    }

    @Override
    public void openItem(Object item) {
        for (OpenAction openAction : this.openActions) {
            openAction.setElement(item);
            if (!openAction.isEnabled()) continue;
            openAction.run();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.selectionListeners.contains(listener)) {
            this.selectionListeners.add(listener);
        }
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    @Override
    public void refreshFromRepository() {
        for (ActivityRepositoryBrowser browser : this.browsers) {
            browser.refresh();
        }
        this.refreshRevisionBranchLabel();
    }

    public void setSelection(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object selObject = ((IStructuredSelection)selection).getFirstElement();
        int idx = 0;
        while (idx < this.browsers.size()) {
            ActivityRepositoryBrowser browser = this.browsers.get(idx);
            List<Class<?>> interfacesOfSelObject = Arrays.asList(selObject.getClass().getInterfaces());
            boolean valid = false;
            if (browser.getControlledObjects().contains(selObject.getClass())) {
                valid = true;
            } else {
                for (Class clazz : browser.getControlledObjects()) {
                    if (!interfacesOfSelObject.contains(clazz)) continue;
                    valid = true;
                    break;
                }
            }
            if (valid) {
                this.tabFolder.setSelection(idx);
                browser.getSelectionProvider().setSelection(selection);
                return;
            }
            ++idx;
        }
    }

    public String getContributorId() {
        return "de.aristaflow.adept2.ui.processvisualisation.ProcessVisualiser";
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(type);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        for (ISelectionChangedListener listener : this.selectionListeners) {
            listener.selectionChanged(event);
        }
        this.currentSelection = event.getSelection();
    }

    @Override
    public Long getWorkingRevision() {
        return this.revision;
    }

    @Override
    public Long getWorkingBranch() {
        return this.branch;
    }

    private void refreshRevisionBranchLabel() {
        if (this.getWorkingBranch() == null) {
            SessionToken session = Activator.getService().getSessionToken();
            ActivityRepository rep = Activator.getService().getActivityRepository();
            boolean isNewestRevision = rep.getRevisionManager().getLatestRevision(session).getRevision() == this.revision.longValue();
            String s = String.format("Working on revision %s %s", this.revision, isNewestRevision ? "(latest)" : "(more recent one available)");
            this.lblHeader.setText(s);
        } else {
            this.lblHeader.setText("Working on branch " + this.branch);
        }
    }

    @Override
    public void setWorkingRevision(long revision) {
        boolean ok = true;
        int i = 0;
        while (i < this.revisionBranchSwitchListeners.size()) {
            RevisionBranchSwitchListener listener = this.revisionBranchSwitchListeners.get(i);
            if (!(ok &= listener.beforeSwitch(this.revision, this.branch, revision, null))) {
                int j = 0;
                while (j < i) {
                    listener = this.revisionBranchSwitchListeners.get(j);
                    listener.cancelLastSwitch();
                    ++j;
                }
                break;
            }
            ++i;
        }
        if (ok) {
            Long oldBranch = this.branch;
            Long oldRevision = this.revision;
            this.branch = null;
            this.revision = revision;
            this.refreshFromRepository();
            if (this.currentSelection != null) {
                SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, this.currentSelection);
                this.selectionChanged(e);
                this.browsers.get(this.tabFolder.getSelectionIndex()).getSelectionProvider().setSelection(this.currentSelection);
            }
            for (RevisionBranchSwitchListener listener : this.revisionBranchSwitchListeners) {
                listener.afterSwitch(oldRevision, oldBranch, revision, null);
            }
        }
    }

    @Override
    public void setWorkingBranch(long branch) {
        boolean ok = true;
        int i = 0;
        while (i < this.revisionBranchSwitchListeners.size()) {
            RevisionBranchSwitchListener listener = this.revisionBranchSwitchListeners.get(i);
            if (!(ok &= listener.beforeSwitch(this.revision, this.branch, null, branch))) {
                int j = 0;
                while (j < i) {
                    listener = this.revisionBranchSwitchListeners.get(j);
                    listener.cancelLastSwitch();
                    ++j;
                }
                break;
            }
            ++i;
        }
        if (ok) {
            Long oldRevision = this.revision;
            Long oldBranch = this.branch;
            this.revision = null;
            this.branch = branch;
            this.refreshFromRepository();
            if (this.currentSelection != null) {
                SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, this.currentSelection);
                this.selectionChanged(e);
                this.browsers.get(this.tabFolder.getSelectionIndex()).getSelectionProvider().setSelection(this.currentSelection);
            }
            for (RevisionBranchSwitchListener listener : this.revisionBranchSwitchListeners) {
                listener.afterSwitch(oldRevision, oldBranch, null, branch);
            }
        }
    }
}

