/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2;

import de.aristaflow.adept2.core.client.AdministrationService;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends AbstractUIPlugin {
    private static final Logger logger = LoggerTools.getLogger(Activator.class);
    private static Activator plugin;

    public Activator() {
        String dataDir;
        String installPath;
        String confDirs = System.getProperty("arflow.confdir");
        try {
            URL url = Platform.getInstallLocation().getURL();
            URI uri = new URI(url.toString().replace(" ", "%20"));
            if (uri.getScheme().equalsIgnoreCase("file")) {
                installPath = new File(uri).getAbsolutePath();
            } else {
                logger.info(String.format("The install location is not a file ('%s'), trying to use '.'.", uri));
                installPath = ".";
            }
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
        File defaultConfDir = new File(String.valueOf(installPath) + File.separator + "conf");
        if (defaultConfDir.exists() && defaultConfDir.isDirectory()) {
            confDirs = confDirs == null || confDirs.equals("") ? defaultConfDir.getPath() : String.valueOf(confDirs) + File.pathSeparator + defaultConfDir.getPath();
        } else {
            logger.info(String.format("Directory %s not found or not a directory, not adding to the configuration directories.", defaultConfDir.getPath()));
        }
        if (confDirs != null) {
            System.setProperty("arflow.confdir", confDirs);
        }
        if ((dataDir = System.getProperty("arflow.datadir")) == null || dataDir.equals("")) {
            dataDir = String.valueOf(installPath) + "/data";
        }
        System.setProperty("arflow.datadir", dataDir);
    }

    public static String getPluginID() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    public void start(BundleContext context) throws Exception {
        plugin = this;
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static AdministrationService getAdministrationService() {
        ServiceReference ref = Activator.getDefault().getBundle().getBundleContext().getServiceReference(AdministrationService.class.getName());
        return (AdministrationService)Activator.getDefault().getBundle().getBundleContext().getService(ref);
    }

    public static Image getImage(String path) {
        Image img = Activator.getDefault().getImageRegistry().get(path);
        if (img == null) {
            img = Activator.getImageDescriptor(path).createImage();
            Activator.getDefault().getImageRegistry().put(path, img);
        }
        return img;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor desc = Activator.imageDescriptorFromPlugin((String)Activator.getPluginID(), (String)path);
        if (desc == null) {
            desc = ImageDescriptor.getMissingImageDescriptor();
        }
        return desc;
    }
}

