/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.applications.automaticclient;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.licensing.LicenceManager;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.client.AdministrationService;
import de.aristaflow.adept2.core.client.ClientBootstrap;
import de.aristaflow.adept2.model.common.LicenceInformation;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.JavaVersion;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.StringTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.configuration.PropertiesConfiguration;

public class AutomaticClientConsole {
    public static void main(String[] args) throws AbortServiceException {
        System.out.println("AristaFlow Automatic Client");
        String versionString = null;
        try {
            PropertiesConfiguration versionProps = new PropertiesConfiguration();
            versionProps.load(AutomaticClientConsole.class.getResourceAsStream("/version"));
            versionString = versionProps.getString("version");
        }
        catch (Exception ex) {
            String msg = String.format("The exception %s will be ignored.", ex);
            LoggerTools.getLogger(AutomaticClientConsole.class).finest(msg);
        }
        if (versionString == null) {
            versionString = "<version info not available>";
        }
        System.out.println("Release: " + versionString);
        System.out.println();
        if (!JavaVersion.getCurrent().satisfiesMinimum("1.5")) {
            String msg = "The AristaFlow Automatic Client requires Java %s to run, but was started with version %s! Shutting down.";
            msg = String.format(msg, "1.5", JavaVersion.getCurrent());
            System.out.println(msg);
            System.exit(-1);
        }
        ClientBootstrap registry = ClientBootstrap.load();
        try {
            try {
                AdministrationService service = (AdministrationService)registry.getClientService();
                ClientSessionFactory[] sessionFactory = new ClientSessionFactory[]{service.getAuthentication().authenticate("system", -2L, "password")};
                service.setAuthenticatedAgents(sessionFactory);
                SessionToken session = service.getSessionToken();
                LicenceManager licMan = registry.getService(session, "/LicenceManager/LicenceManager", LicenceManager.class);
                LicenceInformation licInf = licMan.getLicenceInformation(session);
                System.out.println(StringTools.repeat("=", 79));
                System.out.println(" Licence Information");
                System.out.print("   - licensed to:  ");
                System.out.print(licInf.getLicensee());
                System.out.println();
                System.out.print("   - licence type: ");
                System.out.print(licInf.getLicenceType());
                System.out.println();
                System.out.println(StringTools.repeat("=", 79));
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                boolean running = true;
                while (running) {
                    try {
                        System.out.print("automaticClient> ");
                        String readLine = reader.readLine();
                        if (readLine == null || readLine.equals("shutdown") || readLine.equals("exit")) {
                            running = false;
                            continue;
                        }
                        System.out.println("type 'shutdown' for exit.");
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (AuthenticationException e) {
                System.out.println("Exception while trying to set the session factory for the ADEPT2ServerConsole.");
                e.printStackTrace();
                registry.shutdown();
                System.out.println("Have a nice day.");
            }
            catch (DataSourceException e) {
                System.out.println("Exception while trying to set the session factory for the ADEPT2ServerConsole.");
                e.printStackTrace();
                registry.shutdown();
                System.out.println("Have a nice day.");
            }
        }
        finally {
            registry.shutdown();
            System.out.println("Have a nice day.");
        }
    }
}

