/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.applications.checks;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.client.ClientBootstrap;
import de.aristaflow.adept2.core.client.ModellingClientService;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;

public class CheckTemplate {
    public static void main(String[] args) throws AbortServiceException {
        if (args.length == 0 || args[0].equals("-?") || args[0].equals("/?") || args[0].equals("--help") || args[0].equals("-h")) {
            System.out.println(String.format("ADEPT2 Template check tool. \n  Syntax: \n  check-template [path]+", new Object[0]));
            System.exit(0);
        }
        ClientBootstrap registry = ClientBootstrap.load();
        ModellingClientService service = (ModellingClientService)registry.getClientService();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                Template template;
                String path = stringArray[n2];
                File file = new File(path);
                if (!file.exists()) {
                    System.out.println(String.format("'%s' does not exist, skipping.", path));
                }
                System.out.println(String.format("Loading '%s'...", path));
                ClientSessionFactory[] sessionFactory = new ClientSessionFactory[1];
                try {
                    sessionFactory[0] = service.getAuthentication().authenticate(-2L, -2L, "password");
                }
                catch (AuthenticationException ae) {
                    throw new InternalServiceException("Failed to authenticate at the security manager due to wrongauthentication data. Check the configuration of this DataManager.", ae);
                }
                catch (DataSourceException dse) {
                    throw new InternalServiceException("Failed to authenticate at the security manager due to unavailability of the data.", dse);
                }
                service.setAuthenticatedAgents(sessionFactory);
                ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(service.getProcessModelFactory());
                try {
                    template = xmlImport.getTemplateFromFile(file);
                }
                catch (VersionException e) {
                    System.err.println(String.format("Exception: '%s', loading file '%s'.", e, path));
                    break block13;
                }
                catch (XMLFormatException e) {
                    System.err.println(String.format("Exception: '%s', loading file '%s'.", e, path));
                    break block13;
                }
                catch (FileNotFoundException e) {
                    System.err.println(String.format("Exception: '%s', loading file '%s'.", e, path));
                    break block13;
                }
                catch (IOException e) {
                    System.err.println(String.format("Exception: '%s', loading file '%s'.", e, path));
                    break block13;
                }
                System.out.println(String.format("Checking '%s'...", path));
                ProcessTemplateCheck checks = service.getProcessChecks().getBasicModellingChecks();
                NodeRelations relations = new NodeRelations(template);
                URI checkReportBase = ProcessElementIdentifierTools.getTemplateIdentifier(template, "CheckTemplate");
                CheckReport checkReport = new CheckReport(checkReportBase);
                boolean allOK = checks.performCheck(template, relations, checkReport);
                if (allOK) {
                    System.out.println(String.format("'%s' is ok.", path));
                } else {
                    System.out.println(String.format("'%s' is NOT ok, report summary:", path));
                    checkReport.printReportSummary();
                }
            }
            ++n2;
        }
    }
}

