/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.applications.server;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.licensing.LicenceManager;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.client.AdministrationService;
import de.aristaflow.adept2.core.client.ClientBootstrap;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.processmanager.TemplateManager;
import de.aristaflow.adept2.model.common.LicenceInformation;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.JavaVersion;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.StringTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.UUID;
import org.apache.commons.configuration.PropertiesConfiguration;

public class ADEPT2ServerConsole {
    public static void main(String[] args) {
        System.out.println("AristaFlow Server");
        String versionString = null;
        try {
            PropertiesConfiguration versionProps = new PropertiesConfiguration();
            versionProps.load(ADEPT2ServerConsole.class.getResourceAsStream("/version"));
            versionString = versionProps.getString("version");
        }
        catch (Exception ex) {
            String msg = String.format("The exception %s will be ignored.", ex);
            LoggerTools.getLogger(ADEPT2ServerConsole.class).finest(msg);
        }
        if (versionString == null) {
            versionString = "<version info not available>";
        }
        System.out.println("Release: " + versionString);
        System.out.println();
        if (!JavaVersion.getCurrent().satisfiesMinimum("1.5")) {
            String msg = "The AristaFlow Server requires Java %s to run, but was started with version %s! Shutting down.";
            msg = String.format(msg, "1.5", JavaVersion.getCurrent());
            System.out.println(msg);
            System.exit(-1);
        }
        long start = System.nanoTime();
        try {
            ClientBootstrap registry = ClientBootstrap.load();
            try {
                try {
                    AdministrationService service = (AdministrationService)registry.getClientService();
                    ClientSessionFactory sessionFactory = service.getAuthentication().authenticate("system", -2L, "password");
                    service.setAuthenticatedAgents(new ClientSessionFactory[]{sessionFactory});
                    SessionToken session = service.getSessionToken();
                    LicenceManager licMan = registry.getService(session, "/LicenceManager/LicenceManager", LicenceManager.class);
                    LicenceInformation licInf = licMan.getLicenceInformation(session);
                    System.out.println(StringTools.repeat("=", 79));
                    System.out.println(" Licence Information");
                    System.out.print("   - licensed to:  ");
                    System.out.print(licInf.getLicensee());
                    System.out.println();
                    System.out.print("   - licence type: ");
                    System.out.print(licInf.getLicenceType());
                    System.out.println();
                    System.out.println(StringTools.repeat("=", 79));
                    BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                    boolean running = true;
                    TemplateManager templateManager = service.getProcessManager().getTemplateManager();
                    InstanceManager instanceManager = service.getProcessManager().getInstanceManager();
                    System.out.println(String.format("AristaFlow-Server started in %,.3f seconds.", Float.valueOf((float)(System.nanoTime() - start) / 1.0E9f)));
                    while (running) {
                        try {
                            System.out.print("adept2> ");
                            String readLine = reader.readLine();
                            if (readLine == null || readLine.equals("shutdown") || readLine.equals("exit")) {
                                running = false;
                                continue;
                            }
                            if (readLine.equals("state") || readLine.equals("status")) {
                                System.out.println("  ==================================================");
                                System.out.println("  |                Known  templates                |");
                                System.out.println("  ==================================================");
                                for (UUID templateID : templateManager.getAllTemplateIDs(session)) {
                                    String tName = templateManager.getTemplate(session, templateID).getName();
                                    System.out.println("  Template (" + templateID + "): " + tName);
                                    HashSet<UUID> allInstanceIDs = new HashSet<UUID>(instanceManager.getAllInstanceIDsOf(session, templateID));
                                    if (allInstanceIDs.size() > 0) {
                                        for (UUID instanceID : allInstanceIDs) {
                                            String iName = instanceManager.getInstance(session, instanceID).getName();
                                            System.out.println("   - Instance (" + instanceID + "): " + iName);
                                        }
                                    }
                                    System.out.println("  --------------------------------------------------");
                                }
                                continue;
                            }
                            System.out.println("type 'shutdown' for exit or 'state' for a list of known templates and running instances.");
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (AuthenticationException e) {
                    System.out.println("Exception while trying to set the session factory for the ADEPT2ServerConsole.");
                    e.printStackTrace();
                    registry.shutdown();
                    System.out.println("Have a nice day.");
                }
                catch (DataSourceException e) {
                    System.out.println("Exception while trying to set the session factory for the ADEPT2ServerConsole.");
                    e.printStackTrace();
                    registry.shutdown();
                    System.out.println("Have a nice day.");
                }
            }
            finally {
                registry.shutdown();
                System.out.println("Have a nice day.");
            }
        }
        catch (AbortServiceException ase) {
            ase.printStackTrace();
        }
    }
}

