/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication;

import de.aristaflow.adept2.base.communication.CommunicationStack;
import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.service.InvalidServiceStateException;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CommunicationStackLayer<I, O, T, V>
implements CommunicationStack<I, O> {
    private CommunicationStack<T, V> delegate = null;
    private volatile boolean isShutdown = false;
    int[] syncObject = new int[0];
    private int activeThreads = 0;
    protected final Logger logger = LoggerTools.getLogger(this);

    public CommunicationStackLayer(CommunicationStack<T, V> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Passed delegate must not be null!");
        }
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final O process(URI remoteObjectIdentifier, I input) throws CommunicationStackException {
        if (this.isShutdown) {
            String warningMessage = String.format("Cannot accept request for '%s', a shutdown was initiated!", remoteObjectIdentifier);
            InvalidServiceStateException isse = new InvalidServiceStateException(warningMessage);
            this.logger.log(Level.INFO, warningMessage, isse);
            throw new CommunicationStackException(warningMessage, isse);
        }
        int[] warningMessage = this.syncObject;
        synchronized (this.syncObject) {
            O o;
            ++this.activeThreads;
            // ** MonitorExit[warningMessage] (shouldn't be in output)
            try {
                O output;
                T delegateInput = this.processInput(remoteObjectIdentifier, input);
                V delegateOutput = this.delegate.process(remoteObjectIdentifier, delegateInput);
                o = output = this.processOutput(remoteObjectIdentifier, delegateOutput);
                int[] nArray = this.syncObject;
            }
            catch (Throwable throwable) {
                int[] nArray = this.syncObject;
                synchronized (this.syncObject) {
                    --this.activeThreads;
                    if (this.activeThreads == 0) {
                        this.syncObject.notifyAll();
                    }
                    // ** MonitorExit[var8_10] (shouldn't be in output)
                    throw throwable;
                }
            }
            synchronized (this.syncObject) {
                --this.activeThreads;
                if (this.activeThreads == 0) {
                    this.syncObject.notifyAll();
                }
                // ** MonitorExit[var8_9] (shouldn't be in output)
                return o;
            }
        }
    }

    protected abstract T processInput(URI var1, I var2) throws CommunicationStackException;

    protected abstract O processOutput(URI var1, V var2) throws CommunicationStackException;

    protected abstract void shutdownStackLayer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void shutdown() {
        this.logger.info("Shutdown initiated");
        this.isShutdown = true;
        this.delegate.shutdown();
        int[] nArray = this.syncObject;
        synchronized (this.syncObject) {
            while (true) {
                if (this.activeThreads <= 0) {
                    this.shutdownStackLayer();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                try {
                    this.syncObject.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

