/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication;

import de.aristaflow.adept2.base.communication.CommunicationStack;
import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.service.InvalidServiceStateException;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CommunicationStackTerminator<I, O>
implements CommunicationStack<I, O> {
    protected final Logger logger = LoggerTools.getLogger(this.getClass());
    int[] syncObject = new int[0];
    private int activeThreads = 0;
    private volatile boolean isShutdown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final O process(URI remoteObjectIdentifier, I input) throws CommunicationStackException {
        if (this.isShutdown) {
            String warningMessage = String.format("Cannot accept request for '%s', a shutdown was initiated!", remoteObjectIdentifier);
            InvalidServiceStateException isse = new InvalidServiceStateException(warningMessage);
            this.logger.log(Level.INFO, warningMessage, isse);
            throw new CommunicationStackException(warningMessage, isse);
        }
        int[] nArray = this.syncObject;
        synchronized (this.syncObject) {
            O o;
            ++this.activeThreads;
            // ** MonitorExit[var3_4] (shouldn't be in output)
            try {
                o = this.processInputAndReturn(remoteObjectIdentifier, input);
                int[] nArray2 = this.syncObject;
            }
            catch (Throwable throwable) {
                int[] nArray3 = this.syncObject;
                synchronized (this.syncObject) {
                    --this.activeThreads;
                    if (this.activeThreads == 0) {
                        this.syncObject.notifyAll();
                    }
                    // ** MonitorExit[var5_9] (shouldn't be in output)
                    throw throwable;
                }
            }
            synchronized (this.syncObject) {
                --this.activeThreads;
                if (this.activeThreads == 0) {
                    this.syncObject.notifyAll();
                }
                // ** MonitorExit[var5_8] (shouldn't be in output)
                return o;
            }
        }
    }

    protected abstract O processInputAndReturn(URI var1, I var2) throws CommunicationStackException;

    protected abstract void shutdownStackLayer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void shutdown() {
        this.logger.info("Shutdown initiated");
        this.isShutdown = true;
        int[] nArray = this.syncObject;
        synchronized (this.syncObject) {
            while (true) {
                if (this.activeThreads <= 0) {
                    this.shutdownStackLayer();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                try {
                    this.syncObject.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

