/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication;

import java.io.Serializable;
import java.net.InetAddress;

public abstract class Message
implements Serializable {
    protected final long messageID;
    private InetAddress senderIP;
    private int senderPort;

    public Message(long messageID) {
        this.messageID = messageID;
    }

    public abstract boolean process();

    public long getMessageID() {
        return this.messageID;
    }

    public boolean isReplyMessage() {
        return false;
    }

    public Message generateReplyMessage(long replyMessageID) {
        return null;
    }

    public void setMessageSender(InetAddress ip, int port) {
        this.senderIP = ip;
        this.senderPort = port;
    }

    public InetAddress getSenderIP() {
        return this.senderIP;
    }

    public int getSenderPort() {
        return this.senderPort;
    }

    public String toString() {
        return String.format("with message type '%s' and message id '%s'", this.getClass().getSimpleName(), this.messageID);
    }
}

