/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.communicationservices;

import de.aristaflow.adept2.base.communication.ADEPT2CallbackExport;
import de.aristaflow.adept2.base.communication.ADEPT2CommunicationStackFactory;
import de.aristaflow.adept2.base.communication.ADEPT2RemoteObjectIdentifierFactory;
import de.aristaflow.adept2.base.communication.ADEPT2ServiceExport;
import de.aristaflow.adept2.base.communication.ADEPT2StubFactory;
import de.aristaflow.adept2.base.communication.CommunicationService;
import de.aristaflow.adept2.base.communication.CommunicationStack;
import de.aristaflow.adept2.base.communication.defaultimplementation.DefaultADEPT2CallbackExport;
import de.aristaflow.adept2.base.communication.defaultimplementation.DefaultADEPT2RemoteObjectIdentifierFactory;
import de.aristaflow.adept2.base.communication.defaultimplementation.DefaultADEPT2ServiceExport;
import de.aristaflow.adept2.base.communication.invocation.CallbackInvocationStubFactory;
import de.aristaflow.adept2.base.communication.invocation.InvocationDelegate;
import de.aristaflow.adept2.base.communication.invocation.InvocationMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationReplyMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationStub;
import de.aristaflow.adept2.base.communication.invocation.ServiceInvocationStubFactory;
import de.aristaflow.adept2.base.communication.mina.AbstractMinaServer;
import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.registry.AbstractRegistry;
import de.aristaflow.adept2.base.service.ADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.Enumeration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="IPAddress", type=Property.Type.STRING, description="This property is used to set the address of the socket. This is needed to set the right interface, if e.g. a server has more than one network interface card. If the given address is not registered on the actual machine a configuration exception is thrown. If nothing is provided, the default address of the actual machine will be used."), @Property(name="Port", type=Property.Type.INT, description="This property is used to set the port where the socket should listen for incoming messages. The default port is '50001'.", defaultValue="50001"), @Property(name="Localhost", type=Property.Type.BOOLEAN, description="This property is used to signal, if localhost, i.e. 127.0.0.1, should be used as address. If nothing is provided, false will be assumed.", defaultValue="false"), @Property(name="ClientTimeout", type=Property.Type.LONG, description="The time in milliseconds [ms] the MinaClient waits for server responses. The default timeout is 60 seconds.", defaultValue="60000"), @Property(name="RouterIP", type=Property.Type.STRING, description="This property is used to set the ip address of a network router. This property is used for a workaround to be abled to connect to a server from within a local network.The default value is the empty string.", defaultValue=""), @Property(name="Version", type=Property.Type.STRING, description="This property is used to set the version of the applications. The communication will check, if the version matches, to prohibit possible mismatches in the API.", defaultValue="1.0.1"), @Property(name="KeystoreFile", type=Property.Type.STRING, description="This property is used to set the certificate file that is used for the ssl encryption of the communication.", defaultValue="cert.jks"), @Property(name="KeystorePass", type=Property.Type.STRING, description="This property is used to set the certificate password that is needed for the ssl encryption.", defaultValue="0HoviMg4O3eeKW5kfmLJaI3x8vGG+bzEsjKRdYsIIoY7+8NsB+Dn2BjMhDvkhpOv9pHWuNtiKpOxKKmv9QjvRA+/jdCMZx6ebnZQNECdTiI6DuvyzuAYaZVPx3XefQS4J4lu60BlRg7ftxYr4FuMGwvEEqOOEacL8JOFXXV8IibJdeoS4elqiz5pOKwr2N04Z68BSYc27qTHsopzRA93beNuxEipZ2F/mB/bSe5ZFGQMYvxx6p57GyaE2o6hj/0j/GgUHJtKEWrYUu99lqxvax7Ym0LFnRjJzU8Z/cIQgh22pgYmSYweKKWAmKyrVrW4ypGwlin1ZSEGaB97cxCd5Q=="), @Property(name="UseSSL", type=Property.Type.BOOLEAN, description="This property is used to signal, whether ssl encryption should be used or not.", defaultValue="false"), @Property(name="Client", type=Property.Type.BOOLEAN, description="This property is used to signal, whether this service is used on client or on server side.", isRequired=true), @Property(name="Hostname", type=Property.Type.STRING, description="This property is used to set the address of the socket. If set, the host name will be used in the communication uris (instead of the IP address). If the given address is not registered on the actual machine a configuration exception is thrown. If nothing is provided, the IP address or the default address of the actual machine will be used.", defaultNull=true), @Property(name="UseHostname", type=Property.Type.BOOLEAN, description="This property is used to signal, whether the host name should be used in the communication uris (instead of the IP address). ", defaultValue="false")})
public abstract class AbstractMinaCommunicationService<I, O>
extends AbstractADEPT2Service
implements CommunicationService<I, O, InvocationMessage, InvocationReplyMessage>,
ADEPT2CommunicationStackFactory<I, O, InvocationMessage, InvocationReplyMessage> {
    private final InvocationDelegate invocationDelegate;
    protected ADEPT2RemoteObjectIdentifierFactory roiFactory;
    private final ADEPT2ServiceExport serviceExport;
    private final ADEPT2StubFactory<ADEPT2Service> serviceStubFactory;
    private final ADEPT2CallbackExport callbackExport;
    private final ADEPT2StubFactory<Object> callbackStubFactory;
    protected CommunicationStack<InvocationMessage, InvocationReplyMessage> stubCommunicationStack;
    protected CommunicationStack<I, O> skeletonCommunicationStack;
    protected AbstractMinaServer<I, O> server;
    protected String routerIP;
    private final String SCHEMA_IDENTIFIER;
    public static final String CS_LOCALHOST_FLAG = "Localhost";
    public static final String CS_IP_ADDRESS = "IPAddress";
    public static final String CS_PORT = "Port";
    public static final String CS_ROUTER_IP = "RouterIP";
    public static final String CS_CLIENT_TIMEOUT = "ClientTimeout";
    public static final String CS_VERSION = "Version";
    public static final String CS_SSL_KEYSTORE_FILE = "KeystoreFile";
    public static final String CS_SSL_KEYSTORE_PASS = "KeystorePass";
    public static final String CS_SSL_USAGE = "UseSSL";
    public static final String CS_CLIENT = "Client";
    public static final String CS_HOSTNAME = "Hostname";
    public static final String CS_USE_HOSTNAME = "UseHostname";
    protected InetAddress serverHostIP = null;
    protected int port;
    protected final long clientTimeout;
    protected final String version;
    protected final boolean useSSL;
    protected final String sslCertFileName;
    protected final String sslKeystorePass;
    protected final String hostname;
    protected final boolean useHostname;

    public AbstractMinaCommunicationService(Configuration configuration, Registry registryWrapper, AbstractRegistry registry, String simpleInstanceName) throws ConfigurationException {
        super(configuration, registryWrapper);
        try {
            String infoMessage = "Configure MinaXSCommunicationService...";
            this.logger.info(infoMessage);
            this.version = configuration.getString(CS_VERSION);
            boolean localhost = configuration.getBoolean(CS_LOCALHOST_FLAG);
            infoMessage = String.format("Set localhost flag to '%s'.", localhost);
            this.logger.info(infoMessage);
            this.port = configuration.getInt(CS_PORT);
            this.routerIP = configuration.getString(CS_ROUTER_IP);
            infoMessage = String.format("Set routerIP to '%s'.", this.routerIP);
            this.logger.info(infoMessage);
            this.clientTimeout = configuration.getLong(CS_CLIENT_TIMEOUT);
            infoMessage = String.format("Set client timeout to '%s'.", this.clientTimeout);
            this.logger.info(infoMessage);
            this.SCHEMA_IDENTIFIER = simpleInstanceName;
            infoMessage = String.format("Set SCHEMA_IDENTIFIER to '%s'.", this.SCHEMA_IDENTIFIER);
            this.logger.info(infoMessage);
            this.useHostname = configuration.getBoolean(CS_USE_HOSTNAME);
            this.hostname = configuration.getString(CS_HOSTNAME);
            String ipAddress = configuration.getString(CS_IP_ADDRESS);
            if (localhost) {
                this.serverHostIP = InetAddress.getByName(null);
                infoMessage = String.format("Localhost flag was set to 'TRUE', so set serverHostIP to '%s'!", this.serverHostIP);
                this.logger.info(infoMessage);
            } else if (ipAddress != null && ipAddress.trim().length() != 0) {
                this.serverHostIP = InetAddress.getByName(ipAddress);
                if (this.isRemoteAddress(this.serverHostIP)) {
                    throw new ConfigurationException("The ip address specified in the configuration is not from the actual machine! Cancelling execution!");
                }
                if (this.hostname != null && !this.resolvesHostnameToLocalIPAddress(this.serverHostIP, this.hostname)) {
                    String msg = "Hostname '%s' does not resolve to the configured IP address '%s'.";
                    msg = String.format(msg, this.hostname, ipAddress);
                    this.logger.warning(msg);
                }
                infoMessage = String.format("Set serverHostIP to '%s' as configured!", this.serverHostIP);
                this.logger.info(infoMessage);
            } else if (this.hostname != null && this.hostname.trim().length() != 0) {
                this.serverHostIP = InetAddress.getByName(this.hostname);
                if (this.isRemoteAddress(this.serverHostIP)) {
                    throw new ConfigurationException("The ip address specified in the configuration is not from the actual machine! Cancelling execution!");
                }
                infoMessage = String.format("Set serverHostIP to '%s' as configured!", this.serverHostIP);
                this.logger.info(infoMessage);
            } else {
                this.serverHostIP = InetAddress.getLocalHost();
                infoMessage = String.format("No serverHostIP was configured and localhost flag was not set, so set serverHostIP to default value '%s'!", this.serverHostIP);
                this.logger.info(infoMessage);
            }
            infoMessage = "Configure MinaCommunicationService...done";
            this.logger.info(infoMessage);
        }
        catch (UnknownHostException e) {
            throw new ConfigurationException("Hostname couldn't be resolved! Cancelling execution!", e);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("NumberFormatException for Port: specified value is not of type int! Cancelling execution!", e);
        }
        catch (SocketException socketException) {
            throw new ConfigurationException("SocketException while trying to check whether the configured IP address is from the actual machine.");
        }
        this.useSSL = configuration.getBoolean(CS_SSL_USAGE);
        this.sslCertFileName = configuration.getString(CS_SSL_KEYSTORE_FILE);
        try {
            this.sslKeystorePass = ConfigurationTools.parsePassword(configuration, CS_SSL_KEYSTORE_PASS);
        }
        catch (GeneralSecurityException e) {
            throw new ConfigurationException("The password could not be parsed! Maybe it is not set.", e);
        }
        this.invocationDelegate = new InvocationStub(configuration, registryWrapper, this, this.version);
        this.serviceExport = new DefaultADEPT2ServiceExport(this);
        this.serviceStubFactory = new ServiceInvocationStubFactory(registry, this);
        this.callbackExport = new DefaultADEPT2CallbackExport(this);
        this.callbackStubFactory = new CallbackInvocationStubFactory(this);
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        if (this.server != null) {
            this.server.init();
            this.port = this.server.getPort();
        }
        String ip = this.routerIP != null && this.routerIP.length() > 0 ? this.routerIP : (this.hostname != null ? this.hostname : (this.useHostname ? this.serverHostIP.getHostName() : this.serverHostIP.getHostAddress()));
        this.roiFactory = new DefaultADEPT2RemoteObjectIdentifierFactory(this.SCHEMA_IDENTIFIER, ip, this.port);
        String infoMessage = String.format("Set communication port to '%s'.", this.port);
        this.logger.info(infoMessage);
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.stubCommunicationStack.shutdown();
        this.skeletonCommunicationStack.shutdown();
        if (this.server != null) {
            this.server.normalShutdown();
        }
    }

    @Override
    public void emergencyShutdown() {
        super.emergencyShutdown();
        this.stubCommunicationStack.shutdown();
        this.skeletonCommunicationStack.shutdown();
        if (this.server != null) {
            this.server.emergencyShutdown();
        }
    }

    public static void awaitExecutorServiceShutdown(ExecutorService service) {
        boolean terminated = false;
        while (!terminated) {
            try {
                terminated = service.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public ADEPT2CallbackExport getADEPT2CallbackExport() {
        return this.callbackExport;
    }

    @Override
    public ADEPT2StubFactory<Object> getADEPT2CallbackStubFactory() {
        return this.callbackStubFactory;
    }

    @Override
    public ADEPT2CommunicationStackFactory<I, O, InvocationMessage, InvocationReplyMessage> getADEPT2CommunicationStackFactory() {
        return this;
    }

    @Override
    public ADEPT2ServiceExport getADEPT2ServiceExport() {
        return this.serviceExport;
    }

    @Override
    public ADEPT2StubFactory<ADEPT2Service> getADEPT2ServiceStubFactory() {
        return this.serviceStubFactory;
    }

    @Override
    public ADEPT2RemoteObjectIdentifierFactory getADEPT2RemoteObjectIdentifierFactory() {
        return this.roiFactory;
    }

    @Override
    public InvocationDelegate getInvocationDelegate() {
        return this.invocationDelegate;
    }

    @Override
    public CommunicationStack<I, O> getSkeletonCommunicationStack() {
        return this.skeletonCommunicationStack;
    }

    @Override
    public CommunicationStack<InvocationMessage, InvocationReplyMessage> getStubCommunicationStack() {
        return this.stubCommunicationStack;
    }

    @Override
    public InetAddress getListeningAddress() {
        return this.serverHostIP;
    }

    private boolean isRemoteAddress(InetAddress ipToCheck) throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        boolean remoteAddress = true;
        block0: while (networkInterfaces.hasMoreElements() && remoteAddress) {
            NetworkInterface iface = networkInterfaces.nextElement();
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!address.equals(ipToCheck)) continue;
                remoteAddress = false;
                continue block0;
            }
        }
        return remoteAddress;
    }

    private boolean resolvesHostnameToLocalIPAddress(InetAddress ipToCheck, String hostname) throws UnknownHostException {
        InetAddress[] addr = InetAddress.getAllByName(hostname);
        boolean localAddress = false;
        InetAddress[] inetAddressArray = addr;
        int n = addr.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress ia = inetAddressArray[n2];
            if (ia.equals(ipToCheck)) {
                localAddress = true;
                break;
            }
            ++n2;
        }
        return localAddress;
    }
}

