/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.communicationservices;

import de.aristaflow.adept2.base.communication.ADEPT2CallbackExport;
import de.aristaflow.adept2.base.communication.ADEPT2CommunicationStackFactory;
import de.aristaflow.adept2.base.communication.ADEPT2RemoteObjectIdentifierFactory;
import de.aristaflow.adept2.base.communication.ADEPT2ServiceExport;
import de.aristaflow.adept2.base.communication.ADEPT2StubFactory;
import de.aristaflow.adept2.base.communication.CommunicationService;
import de.aristaflow.adept2.base.communication.CommunicationStack;
import de.aristaflow.adept2.base.communication.defaultimplementation.DefaultADEPT2CallbackExport;
import de.aristaflow.adept2.base.communication.defaultimplementation.DefaultADEPT2RemoteObjectIdentifierFactory;
import de.aristaflow.adept2.base.communication.defaultimplementation.DefaultADEPT2ServiceExport;
import de.aristaflow.adept2.base.communication.invocation.CallbackInvocationStubFactory;
import de.aristaflow.adept2.base.communication.invocation.InvocationDelegate;
import de.aristaflow.adept2.base.communication.invocation.InvocationMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationReplyMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationSkeleton;
import de.aristaflow.adept2.base.communication.invocation.InvocationStub;
import de.aristaflow.adept2.base.communication.invocation.ServiceInvocationStubFactory;
import de.aristaflow.adept2.base.communication.local.LocalClient;
import de.aristaflow.adept2.base.communication.local.LocalServer;
import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.registry.AbstractRegistry;
import de.aristaflow.adept2.base.service.ADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="Port", type=Property.Type.INT, description="This property is used to set the port where the socket should listen for incoming messages. The default port is '50001'.", defaultValue="50001"), @Property(name="ClientTimeout", type=Property.Type.LONG, description="The time in milliseconds [ms] the MinaClient waits for server responses. The default timeout is 60 seconds.", defaultValue="60000"), @Property(name="ServerTimeout", type=Property.Type.LONG, description="The time in milliseconds [ms] the MinaServer waits for server requests. The default timeout is 60 seconds.", defaultValue="60000"), @Property(name="Version", type=Property.Type.STRING, description="This property is used to set the version of the applications. The communication will check, if the version matches, to prohibit possible mismatches in the API.", defaultValue="Release0808")})
public class LocalCommunicationService
extends AbstractADEPT2Service
implements CommunicationService<InvocationMessage, InvocationReplyMessage, InvocationMessage, InvocationReplyMessage>,
ADEPT2CommunicationStackFactory<InvocationMessage, InvocationReplyMessage, InvocationMessage, InvocationReplyMessage> {
    private final InvocationDelegate invocationDelegate;
    protected ADEPT2RemoteObjectIdentifierFactory roiFactory;
    private final ADEPT2ServiceExport serviceExport;
    private final ADEPT2StubFactory<ADEPT2Service> serviceStubFactory;
    private final ADEPT2CallbackExport callbackExport;
    private final ADEPT2StubFactory<Object> callbackStubFactory;
    protected CommunicationStack<InvocationMessage, InvocationReplyMessage> stubCommunicationStack;
    private final CommunicationStack<InvocationMessage, InvocationReplyMessage> skeletonCommunicationStack;
    protected LocalServer server;
    private final String SCHEMA_IDENTIFIER;
    public static final String CS_PORT = "Port";
    public static final String CS_CLIENT_TIMEOUT = "ClientTimeout";
    public static final String CS_SERVER_TIMEOUT = "ServerTimeout";
    public static final String CS_VERSION = "Version";
    protected int port;
    protected final long clientTimeout;
    protected final long serverTimeout;
    protected InetAddress serverHostIP;

    public LocalCommunicationService(Configuration configuration, Registry registryWrapper, AbstractRegistry registry, String simpleInstanceName) {
        super(configuration, registryWrapper);
        String infoMessage = "Configure MinaCommunicationService...";
        this.logger.info(infoMessage);
        String version = configuration.getString(CS_VERSION);
        int configuredPort = configuration.getInt(CS_PORT);
        this.clientTimeout = configuration.getLong(CS_CLIENT_TIMEOUT);
        infoMessage = String.format("Set client timeout to '%s'.", this.clientTimeout);
        this.logger.info(infoMessage);
        this.serverTimeout = configuration.getLong(CS_SERVER_TIMEOUT);
        infoMessage = String.format("Set server timeout to '%s'.", this.serverTimeout);
        this.logger.info(infoMessage);
        this.SCHEMA_IDENTIFIER = simpleInstanceName;
        infoMessage = String.format("Set SCHEMA_IDENTIFIER to '%s'.", this.SCHEMA_IDENTIFIER);
        this.logger.info(infoMessage);
        this.invocationDelegate = new InvocationStub(configuration, registryWrapper, this, version);
        this.skeletonCommunicationStack = new InvocationSkeleton(this, version);
        this.stubCommunicationStack = new LocalClient(this.clientTimeout);
        this.serviceExport = new DefaultADEPT2ServiceExport(this);
        this.serviceStubFactory = new ServiceInvocationStubFactory(registry, this);
        this.callbackExport = new DefaultADEPT2CallbackExport(this);
        this.callbackStubFactory = new CallbackInvocationStubFactory(this);
        this.server = new LocalServer(this, configuredPort);
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        this.server.init();
        this.port = this.server.getPort();
        String ip = "127.0.0.1";
        try {
            this.serverHostIP = InetAddress.getByName(null);
            ip = this.serverHostIP.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            this.logger.warning("Hostname couldn't be resolved! Using '127.0.0.1'!");
        }
        this.roiFactory = new DefaultADEPT2RemoteObjectIdentifierFactory(this.SCHEMA_IDENTIFIER, ip, this.port);
        String infoMessage = String.format("Set communication port to '%s'.", this.port);
        this.logger.info(infoMessage);
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        this.server.start();
    }

    @Override
    public void shutdown() {
        this.server.shutdown();
        this.skeletonCommunicationStack.shutdown();
        this.stubCommunicationStack.shutdown();
        super.shutdown();
    }

    @Override
    public void emergencyShutdown() {
        this.server.emergencyShutdown();
        this.skeletonCommunicationStack.shutdown();
        this.stubCommunicationStack.shutdown();
        super.emergencyShutdown();
    }

    @Override
    public ADEPT2CallbackExport getADEPT2CallbackExport() {
        return this.callbackExport;
    }

    @Override
    public ADEPT2StubFactory<Object> getADEPT2CallbackStubFactory() {
        return this.callbackStubFactory;
    }

    @Override
    public ADEPT2CommunicationStackFactory<InvocationMessage, InvocationReplyMessage, InvocationMessage, InvocationReplyMessage> getADEPT2CommunicationStackFactory() {
        return this;
    }

    @Override
    public ADEPT2ServiceExport getADEPT2ServiceExport() {
        return this.serviceExport;
    }

    @Override
    public ADEPT2StubFactory<ADEPT2Service> getADEPT2ServiceStubFactory() {
        return this.serviceStubFactory;
    }

    @Override
    public ADEPT2RemoteObjectIdentifierFactory getADEPT2RemoteObjectIdentifierFactory() {
        return this.roiFactory;
    }

    @Override
    public InvocationDelegate getInvocationDelegate() {
        return this.invocationDelegate;
    }

    @Override
    public CommunicationStack<InvocationMessage, InvocationReplyMessage> getSkeletonCommunicationStack() {
        return this.skeletonCommunicationStack;
    }

    @Override
    public CommunicationStack<InvocationMessage, InvocationReplyMessage> getStubCommunicationStack() {
        return this.stubCommunicationStack;
    }

    @Override
    public InetAddress getListeningAddress() {
        return this.serverHostIP;
    }
}

