/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.communicationservices;

import de.aristaflow.adept2.base.communication.ADEPT2CallbackExport;
import de.aristaflow.adept2.base.communication.ADEPT2CommunicationStackFactory;
import de.aristaflow.adept2.base.communication.ADEPT2RemoteObjectIdentifierFactory;
import de.aristaflow.adept2.base.communication.ADEPT2ServiceExport;
import de.aristaflow.adept2.base.communication.ADEPT2StubFactory;
import de.aristaflow.adept2.base.communication.CommunicationService;
import de.aristaflow.adept2.base.communication.CommunicationStack;
import de.aristaflow.adept2.base.communication.defaultimplementation.DefaultADEPT2CallbackExport;
import de.aristaflow.adept2.base.communication.defaultimplementation.DefaultADEPT2RemoteObjectIdentifierFactory;
import de.aristaflow.adept2.base.communication.defaultimplementation.DefaultADEPT2ServiceExport;
import de.aristaflow.adept2.base.communication.invocation.CallbackInvocationStubFactory;
import de.aristaflow.adept2.base.communication.invocation.InvocationDelegate;
import de.aristaflow.adept2.base.communication.invocation.InvocationMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationReplyMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationSkeleton;
import de.aristaflow.adept2.base.communication.invocation.InvocationStub;
import de.aristaflow.adept2.base.communication.invocation.ServiceInvocationStubFactory;
import de.aristaflow.adept2.base.communication.serialisation.XStreamDeserialiserSerialiser;
import de.aristaflow.adept2.base.communication.serialisation.XStreamSerialiserDeserialiser;
import de.aristaflow.adept2.base.communication.tcp_ip.TCP_IP_Client;
import de.aristaflow.adept2.base.communication.tcp_ip.TCP_IP_Server;
import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.registry.AbstractRegistry;
import de.aristaflow.adept2.base.service.ADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="IPAddress", type=Property.Type.STRING, description="This property is used to set the address of the socket. This is needed to set the right interface, if e.g. a server has more than one network interface card. If the given address is not registered on the actual machine a configuration exception is thrown. If nothing is provided, the default address of the actual machine will be used."), @Property(name="Port", type=Property.Type.INT, description="This property is used to set the port where the socket should listen for incoming messages. The default port is '50001'.", defaultValue="50001"), @Property(name="Localhost", type=Property.Type.BOOLEAN, description="This property is used to signal, if localhost, i.e. 127.0.0.1, should be used as address. If nothing is provided, false will be assumed.", defaultValue="false"), @Property(name="ClientTimeout", type=Property.Type.LONG, description="The time in milliseconds [ms] the TCP_IP_Client waits for server responses. The default timeout is 60 seconds.", defaultValue="60000"), @Property(name="ServerTimeout", type=Property.Type.LONG, description="The time in milliseconds [ms] the TCP_IP_Server waits for server requests. The default timeout is 60 seconds.", defaultValue="60000"), @Property(name="RouterIP", type=Property.Type.STRING, description="This property is used to set the ip address of a network router. This property is used for a workaround to be abled to connect to a server from within a local network.The default value is the empty string.", defaultValue=""), @Property(name="Version", type=Property.Type.STRING, description="This property is used to set the version of the applications. The communication will check, if the version matches, to prohibit possible mismatches in the API.", defaultValue="Release0808")})
public class TCP_IP_Invocation_CommunicationService
extends AbstractADEPT2Service
implements CommunicationService<byte[], byte[], InvocationMessage, InvocationReplyMessage>,
ADEPT2CommunicationStackFactory<byte[], byte[], InvocationMessage, InvocationReplyMessage> {
    private final InvocationDelegate invocationDelegate;
    protected ADEPT2RemoteObjectIdentifierFactory roiFactory;
    private final ADEPT2ServiceExport serviceExport;
    private final ADEPT2StubFactory<ADEPT2Service> serviceStubFactory;
    private final ADEPT2CallbackExport callbackExport;
    private final ADEPT2StubFactory<Object> callbackStubFactory;
    protected CommunicationStack<InvocationMessage, InvocationReplyMessage> stubCommunicationStack;
    private final CommunicationStack<byte[], byte[]> skeletonCommunicationStack;
    protected TCP_IP_Server server;
    protected String routerIP;
    private final String SCHEMA_IDENTIFIER;
    public static final String CS_TCP_IP_INVOCATION_LOCALHOST_FLAG = "Localhost";
    public static final String CS_TCP_IP_INVOCATION_IP_ADDRESS = "IPAddress";
    public static final String CS_TCP_IP_INVOCATION_PORT = "Port";
    public static final String CS_TCP_IP_INVOCATION_ROUTER_IP = "RouterIP";
    public static final String CS_TCP_IP_INVOCATION_CLIENT_TIMEOUT = "ClientTimeout";
    public static final String CS_TCP_IP_INVOCATION_SERVER_TIMEOUT = "ServerTimeout";
    public static final String CS_TCP_IP_INVOCATION_VERSION = "Version";
    protected InetAddress serverHostIP = null;
    protected int port;
    protected final long clientTimeout;
    protected final long serverTimeout;

    public TCP_IP_Invocation_CommunicationService(Configuration configuration, Registry registryWrapper, AbstractRegistry registry, String simpleInstanceName) throws ConfigurationException {
        super(configuration, registryWrapper);
        int configuredPort;
        String version;
        try {
            String infoMessage = "Configure TCP_IP_Invocation_CommunicationService...";
            this.logger.info(infoMessage);
            version = configuration.getString(CS_TCP_IP_INVOCATION_VERSION);
            boolean localhost = configuration.getBoolean(CS_TCP_IP_INVOCATION_LOCALHOST_FLAG);
            infoMessage = String.format("Set localhost flag to '%s'.", localhost);
            this.logger.info(infoMessage);
            configuredPort = configuration.getInt(CS_TCP_IP_INVOCATION_PORT);
            this.routerIP = configuration.getString(CS_TCP_IP_INVOCATION_ROUTER_IP);
            infoMessage = String.format("Set routerIP to '%s'.", this.routerIP);
            this.logger.info(infoMessage);
            this.clientTimeout = configuration.getLong(CS_TCP_IP_INVOCATION_CLIENT_TIMEOUT);
            infoMessage = String.format("Set client timeout to '%s'.", this.clientTimeout);
            this.logger.info(infoMessage);
            this.serverTimeout = configuration.getLong(CS_TCP_IP_INVOCATION_SERVER_TIMEOUT);
            infoMessage = String.format("Set server timeout to '%s'.", this.serverTimeout);
            this.logger.info(infoMessage);
            this.SCHEMA_IDENTIFIER = simpleInstanceName;
            infoMessage = String.format("Set SCHEMA_IDENTIFIER to '%s'.", this.SCHEMA_IDENTIFIER);
            this.logger.info(infoMessage);
            String ipAddress = configuration.getString(CS_TCP_IP_INVOCATION_IP_ADDRESS);
            if (localhost) {
                this.serverHostIP = InetAddress.getByName(null);
                infoMessage = String.format("Localhost flag was set to 'TRUE', so set serverHostIP to '%s'!", this.serverHostIP);
                this.logger.info(infoMessage);
            } else if (ipAddress != null && ipAddress.trim().length() != 0) {
                this.serverHostIP = InetAddress.getByName(ipAddress);
                if (this.isRemoteAddress(this.serverHostIP)) {
                    throw new ConfigurationException("The ip address specified in the configuration is not from the actual machine! Cancelling execution!");
                }
                infoMessage = String.format("Set serverHostIP to '%s' as configured!", this.serverHostIP);
                this.logger.info(infoMessage);
            } else {
                this.serverHostIP = InetAddress.getLocalHost();
                infoMessage = String.format("No serverHostIP was configured and localhost flag was not set, so set serverHostIP to default value '%s'!", this.serverHostIP);
                this.logger.info(infoMessage);
            }
            infoMessage = "Configure TCP_IP_Invocation_CommunicationService...done";
            this.logger.info(infoMessage);
        }
        catch (UnknownHostException e) {
            throw new ConfigurationException("Hostname couldn't be resolved! Cancelling execution!", e);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("NumberFormatException for Port: specified value is not of type int! Cancelling execution!", e);
        }
        catch (SocketException socketException) {
            throw new ConfigurationException("SocketException while trying to check whether the configured IP address is from the actual machine.");
        }
        this.invocationDelegate = new InvocationStub(configuration, registryWrapper, this, version);
        InvocationSkeleton skeletonStackTerminator = new InvocationSkeleton(this, version);
        this.skeletonCommunicationStack = new XStreamDeserialiserSerialiser<InvocationMessage, InvocationReplyMessage>(skeletonStackTerminator);
        TCP_IP_Client stubStackTerminator = new TCP_IP_Client(this.clientTimeout);
        this.stubCommunicationStack = new XStreamSerialiserDeserialiser<InvocationMessage, InvocationReplyMessage>(stubStackTerminator);
        this.serviceExport = new DefaultADEPT2ServiceExport(this);
        this.serviceStubFactory = new ServiceInvocationStubFactory(registry, this);
        this.callbackExport = new DefaultADEPT2CallbackExport(this);
        this.callbackStubFactory = new CallbackInvocationStubFactory(this);
        this.server = new TCP_IP_Server(this, this.serverHostIP, configuredPort, this.serverTimeout, this.getADEPT2CommunicationStackFactory());
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        this.server.init();
        this.port = this.server.getPort();
        String ip = this.routerIP != null && this.routerIP.length() > 0 ? this.routerIP : this.serverHostIP.getHostAddress();
        this.roiFactory = new DefaultADEPT2RemoteObjectIdentifierFactory(this.SCHEMA_IDENTIFIER, ip, this.port);
        String infoMessage = String.format("Set communication port to '%s'.", this.port);
        this.logger.info(infoMessage);
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        this.server.start();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.server.shutdown();
        this.skeletonCommunicationStack.shutdown();
        this.stubCommunicationStack.shutdown();
    }

    @Override
    public void emergencyShutdown() {
        super.emergencyShutdown();
        this.server.emergencyShutdown();
        this.skeletonCommunicationStack.shutdown();
        this.stubCommunicationStack.shutdown();
    }

    @Override
    public ADEPT2CallbackExport getADEPT2CallbackExport() {
        return this.callbackExport;
    }

    @Override
    public ADEPT2StubFactory<Object> getADEPT2CallbackStubFactory() {
        return this.callbackStubFactory;
    }

    @Override
    public ADEPT2CommunicationStackFactory<byte[], byte[], InvocationMessage, InvocationReplyMessage> getADEPT2CommunicationStackFactory() {
        return this;
    }

    @Override
    public ADEPT2ServiceExport getADEPT2ServiceExport() {
        return this.serviceExport;
    }

    @Override
    public ADEPT2StubFactory<ADEPT2Service> getADEPT2ServiceStubFactory() {
        return this.serviceStubFactory;
    }

    @Override
    public ADEPT2RemoteObjectIdentifierFactory getADEPT2RemoteObjectIdentifierFactory() {
        return this.roiFactory;
    }

    @Override
    public InvocationDelegate getInvocationDelegate() {
        return this.invocationDelegate;
    }

    @Override
    public CommunicationStack<byte[], byte[]> getSkeletonCommunicationStack() {
        return this.skeletonCommunicationStack;
    }

    @Override
    public CommunicationStack<InvocationMessage, InvocationReplyMessage> getStubCommunicationStack() {
        return this.stubCommunicationStack;
    }

    @Override
    public InetAddress getListeningAddress() {
        return this.serverHostIP;
    }

    private boolean isRemoteAddress(InetAddress ipToCheck) throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        boolean remoteAddress = true;
        block0: while (networkInterfaces.hasMoreElements() && remoteAddress) {
            NetworkInterface iface = networkInterfaces.nextElement();
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!address.equals(ipToCheck)) continue;
                remoteAddress = false;
                continue block0;
            }
        }
        return remoteAddress;
    }
}

