/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.defaultimplementation;

import de.aristaflow.adept2.base.communication.ADEPT2CallbackExport;
import de.aristaflow.adept2.base.communication.ADEPT2RemoteObjectIdentifierFactory;
import de.aristaflow.adept2.base.communication.CommunicationService;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class DefaultADEPT2CallbackExport
implements ADEPT2CallbackExport {
    private final Logger logger = LoggerTools.getLogger(this);
    private final CommunicationService<?, ?, ?, ?> communicationService;
    private Map<URI, Object> registeredCallbacks = new HashMap<URI, Object>();
    private Map<URI, Class<?>> registeredInterfaces = new HashMap();
    private Map<Object, URI> registeredURIs = new HashMap<Object, URI>();

    public DefaultADEPT2CallbackExport(CommunicationService<?, ?, ?, ?> communicationService) {
        this.communicationService = communicationService;
    }

    @Override
    public synchronized URI exportCallback(Class<?> callbackInterface, Object callbackObject) {
        int size = this.registeredURIs.size();
        String msg = String.format("Export callback for %s. (%d)", callbackObject, size);
        this.logger.finest(msg);
        URI callbackURI = this.registeredURIs.get(callbackObject);
        if (callbackURI == null) {
            ADEPT2RemoteObjectIdentifierFactory roiFactory = this.communicationService.getADEPT2RemoteObjectIdentifierFactory();
            callbackURI = roiFactory.createCallbackIdentifier(callbackInterface);
            this.registeredCallbacks.put(callbackURI, callbackObject);
            this.registeredInterfaces.put(callbackURI, callbackInterface);
            int size1 = this.registeredURIs.size();
            this.registeredURIs.put(callbackObject, callbackURI);
            int size2 = this.registeredURIs.size();
            msg = String.format("Register callback URI [%s] for %s. (%d -> %d)", callbackURI, callbackObject, size1, size2);
            this.logger.finest(msg);
        }
        return callbackURI;
    }

    @Override
    public synchronized Class<?> getCallbackInterface(URI callbackURI) {
        return this.registeredInterfaces.get(callbackURI);
    }

    @Override
    public synchronized Object getCallbackObject(URI callbackURI) {
        return this.registeredCallbacks.get(callbackURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI revokeCallbackExport(Object callbackObject) {
        if (callbackObject != null) {
            DefaultADEPT2CallbackExport defaultADEPT2CallbackExport = this;
            synchronized (defaultADEPT2CallbackExport) {
                int size1 = this.registeredURIs.size();
                URI callbackURI = this.registeredURIs.remove(callbackObject);
                int size2 = this.registeredURIs.size();
                String msg = String.format("Remove callback URI for %s. (%d -> %d)", callbackObject, size1, size2);
                this.logger.finest(msg);
                if (callbackURI != null) {
                    this.registeredCallbacks.remove(callbackURI);
                    this.registeredInterfaces.remove(callbackURI);
                } else {
                    msg = String.format("No callback URI was registered for %s.", callbackObject);
                    this.logger.finer(msg);
                }
                return callbackURI;
            }
        }
        return null;
    }

    @Override
    public synchronized boolean isRegisteredCallbackURI(URI remoteObjectIdentifier) {
        return this.registeredCallbacks.containsKey(remoteObjectIdentifier);
    }

    @Override
    public synchronized URI getCallbackURIForObject(Object callbackObject) {
        int size = this.registeredURIs.size();
        String msg = String.format("Get callback URI for %s. (%d)", callbackObject, size);
        this.logger.finest(msg);
        URI uri = this.registeredURIs.get(callbackObject);
        if (uri == null) {
            msg = String.format("Found no callback URI for the given callback object %s!", callbackObject);
            this.logger.warning(msg);
        }
        return uri;
    }
}

