/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.defaultimplementation;

import de.aristaflow.adept2.base.communication.ADEPT2RemoteObjectIdentifierFactory;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;

public class DefaultADEPT2RemoteObjectIdentifierFactory
implements ADEPT2RemoteObjectIdentifierFactory {
    private final String schemaIdentifier;
    private long nextCallbackID = 0L;
    private final String hostname;
    private final int port;
    private Logger logger = LoggerTools.getLogger(this);

    public DefaultADEPT2RemoteObjectIdentifierFactory(String simpleInstanceName, String hostname, int port) {
        this.schemaIdentifier = simpleInstanceName;
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    public URI createCallbackIdentifier(Class<?> callbackInterface) {
        URI callbackURI;
        try {
            callbackURI = new URI(this.schemaIdentifier, null, this.hostname, this.port, "/" + callbackInterface.getCanonicalName(), Long.toString(this.generateCallbackID()), null);
        }
        catch (URISyntaxException e) {
            String errorMessage = String.format("Cannot create CallbackIdentifier, an URISyntaxException occurred.", new Object[0]);
            throw new RuntimeException(errorMessage, e);
        }
        return callbackURI;
    }

    @Override
    public URI createRemoteObjectIdentifier(String serviceType, String serviceInstance) {
        URI remoteObjectIdentifier;
        try {
            remoteObjectIdentifier = new URI(this.schemaIdentifier, null, this.hostname, this.port, "/" + serviceType + "/" + serviceInstance, null, null);
        }
        catch (URISyntaxException e) {
            String errorMessage = String.format("Cannot create remote object identifier, an URISyntaxException occurred.", new Object[0]);
            throw new RuntimeException(errorMessage, e);
        }
        return remoteObjectIdentifier;
    }

    @Override
    public void checkServiceURI(URI serviceURI) {
        String path;
        String message = null;
        if (serviceURI.getScheme() == null || !serviceURI.getScheme().equals(this.schemaIdentifier)) {
            message = String.format("The schema of the service URI '%s' is not valid for this communication service.", serviceURI);
        }
        if ((path = serviceURI.getPath()) == null || path.equals("")) {
            message = String.format("The path '%s' is not a valid format of a hierarchical instance name.", path);
        } else if (!path.startsWith("/") || path.lastIndexOf("/") <= 1) {
            message = String.format("The path '%s' is not a valid format of a hierarchical instance name.", path);
        }
        if (message != null) {
            this.logger.warning(message);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public String getInstanceNameFromServiceURI(URI serviceURI) {
        this.checkServiceURI(serviceURI);
        return serviceURI.getPath();
    }

    private synchronized long generateCallbackID() {
        return this.nextCallbackID++;
    }
}

