/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.defaultimplementation;

import de.aristaflow.adept2.base.communication.ADEPT2RemoteObjectIdentifierFactory;
import de.aristaflow.adept2.base.communication.ADEPT2ServiceExport;
import de.aristaflow.adept2.base.communication.CommunicationService;
import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.ADEPT2Service;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultADEPT2ServiceExport
implements ADEPT2ServiceExport {
    protected final CommunicationService<?, ?, ?, ?> communicationService;
    protected final Map<URI, Class<? extends ADEPT2Service>> serviceInterfaces;
    protected final Set<URI> preparedServices;
    protected final Map<URI, ADEPT2Service> exportedServices;

    public DefaultADEPT2ServiceExport(CommunicationService<?, ?, ?, ?> communicationService) {
        this.communicationService = communicationService;
        this.serviceInterfaces = new HashMap<URI, Class<? extends ADEPT2Service>>();
        this.preparedServices = new HashSet<URI>();
        this.exportedServices = new HashMap<URI, ADEPT2Service>();
    }

    @Override
    public URI prepareServiceExport(String serviceType, String simpleServiceName, Class<? extends ADEPT2Service> serviceInterface) throws AbortServiceException {
        ADEPT2RemoteObjectIdentifierFactory roiFactory = this.communicationService.getADEPT2RemoteObjectIdentifierFactory();
        URI remoteObjectIdentifier = roiFactory.createRemoteObjectIdentifier(serviceType, simpleServiceName);
        this.preparedServices.add(remoteObjectIdentifier);
        return remoteObjectIdentifier;
    }

    @Override
    public void exportService(URI serviceURI, Class<? extends ADEPT2Service> serviceInterface, ADEPT2Service service) throws AbortServiceException {
        if (!this.isExportPrepared(serviceURI)) {
            String errMsg = String.format("The service export of service '%s' of type '%s' has not been prepared!", serviceURI, serviceInterface);
            throw new IllegalArgumentException(errMsg);
        }
        if (this.isRegisteredService(serviceURI)) {
            String errMsg = String.format("There is already a service of type '%s' associated with the serviceURI '%s'!", serviceInterface, serviceURI);
            throw new IllegalArgumentException(errMsg);
        }
        this.serviceInterfaces.put(serviceURI, serviceInterface);
        this.exportedServices.put(serviceURI, service);
        this.preparedServices.remove(serviceURI);
    }

    @Override
    public void unregisterService(URI serviceURI) {
        this.serviceInterfaces.remove(serviceURI);
        this.exportedServices.remove(serviceURI);
    }

    @Override
    public Collection<Class<? extends ADEPT2Service>> getExportedServices() {
        return Collections.unmodifiableCollection(this.serviceInterfaces.values());
    }

    @Override
    public ADEPT2Service getExportedService(URI remoteObjectIdentifier) {
        return this.exportedServices.get(remoteObjectIdentifier);
    }

    public Class<? extends ADEPT2Service> getRemoteInterfaceForExportedService(URI remoteObjectIdentifier) {
        return this.serviceInterfaces.get(remoteObjectIdentifier);
    }

    @Override
    public boolean isExportPrepared(URI remoteObjectIdentifier) {
        return this.preparedServices.contains(remoteObjectIdentifier);
    }

    @Override
    public boolean isRegisteredService(URI remoteObjectIdentifier) {
        return this.exportedServices.containsKey(remoteObjectIdentifier);
    }
}

