/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.invocation;

import de.aristaflow.adept2.base.communication.CommunicationService;
import de.aristaflow.adept2.base.communication.invocation.InvocationMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationReplyMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationStubFactory;
import java.net.URI;
import java.util.logging.Level;

public class CallbackInvocationStubFactory
extends InvocationStubFactory<Object> {
    public CallbackInvocationStubFactory(CommunicationService<?, ?, InvocationMessage, InvocationReplyMessage> communicationService) {
        super(communicationService);
    }

    @Override
    protected <T> void checkRemoteInterfaceAgainstRemoteObjectIdentifier(URI remoteObjectIdentifier, Class<T> remoteInterface) {
        Class<?> interfaceForComponentType;
        try {
            interfaceForComponentType = Class.forName(remoteObjectIdentifier.getPath().split("/")[1]);
        }
        catch (ClassNotFoundException e) {
            String message = "The class " + remoteObjectIdentifier.getPath().split("/")[1] + " could not be found, cant check for type safety!";
            this.logger.log(Level.SEVERE, message, e);
            throw new IllegalArgumentException(message, e);
        }
        if (interfaceForComponentType != null && !remoteInterface.isAssignableFrom(interfaceForComponentType)) {
            String message = String.format("The interface encoded in the URI '%s', does not match the interface given as type parameter ('%s')!", remoteObjectIdentifier, remoteInterface.getCanonicalName());
            this.logger.severe(message);
        }
    }
}

