/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.invocation;

import de.aristaflow.adept2.base.communication.ADEPT2CallbackExport;
import de.aristaflow.adept2.base.communication.annotations.DeregisterCallback;
import de.aristaflow.adept2.base.communication.annotations.ProxyAllow;
import de.aristaflow.adept2.base.communication.annotations.ProxyCallback;
import de.aristaflow.adept2.base.communication.annotations.ProxyFollow;
import de.aristaflow.adept2.base.communication.annotations.ProxyIgnore;
import de.aristaflow.adept2.base.communication.annotations.RegisterCallback;
import de.aristaflow.adept2.base.communication.invocation.InvocationDelegate;
import de.aristaflow.adept2.base.communication.tools.CommunicationHelperTools;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.StackTraceTools;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;

public class InvocationHandler<T>
implements java.lang.reflect.InvocationHandler {
    protected final Logger logger = LoggerTools.getLogger(this);
    private static Class<?>[] blackListedFollowTypes = new Class[]{Void.class, Integer.TYPE, Long.TYPE, Boolean.TYPE, Integer.class};
    private final InvocationDelegate delegate;
    private final URI remoteObjectIdentifier;
    private Stack<Method> preceder = new Stack();
    private final Class<T> iface;
    private final Set<Method> ignoredMethods = new HashSet<Method>();
    private final Map<Method, Object> followMethods = new HashMap<Method, Object>();
    private T proxy;
    private final ADEPT2CallbackExport callbackExport;

    public InvocationHandler(ADEPT2CallbackExport callbackExport, InvocationDelegate delegate, URI remoteObjectIdentifier, Class<T> remoteObjectInterface) {
        this.callbackExport = callbackExport;
        this.delegate = delegate;
        this.remoteObjectIdentifier = remoteObjectIdentifier;
        this.iface = remoteObjectInterface;
        this.checkIface();
        this.init();
    }

    protected InvocationHandler(ADEPT2CallbackExport callbackExport, InvocationDelegate delegate, URI remoteObjectIdentifier, Stack<Method> preceder) {
        this.callbackExport = callbackExport;
        this.delegate = delegate;
        this.remoteObjectIdentifier = remoteObjectIdentifier;
        this.preceder = preceder;
        this.iface = preceder.peek().getReturnType();
        this.checkIface();
        this.init();
    }

    private void checkIface() {
        if (!this.iface.isAnnotationPresent(ProxyAllow.class) && !this.iface.isAnnotationPresent(ProxyCallback.class)) {
            String message = String.format("The interface '%1$s' does not allow for calls using a proxy.", this.iface.getSimpleName());
            this.logger.severe(message);
            throw new IllegalArgumentException(message);
        }
    }

    private void init() {
        Method[] methodArray = this.iface.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(ProxyIgnore.class)) {
                this.logger.info(String.format("Ignoring method '%1$s' in class/interface '%2$s'.", method.getName(), this.iface.getName()));
                this.ignoredMethods.add(method);
            } else if (method.isAnnotationPresent(ProxyFollow.class)) {
                this.logger.info(String.format("Following the interface of method '%1$s' in class/interface '%2$s'.", method.getName(), this.iface.getName()));
                if (method.getParameterTypes().length > 0) {
                    String message = String.format("The method '%1$s' in class / interface '%2$s' is not allowed to be marked as ProxyFollow, it has parameters!", method, this.iface);
                    this.logger.severe(message);
                    throw new IllegalArgumentException(message);
                }
                Class<?> returnType = method.getReturnType();
                if (Arrays.asList(blackListedFollowTypes).contains(returnType)) {
                    String message = String.format("Return type '%1$s' of the method '%2$s' in class / interface '%3$s' is not allowed to be marked as '%4$s'!", returnType, method, this.iface, ProxyFollow.class.getSimpleName());
                    this.logger.severe(message);
                    throw new IllegalArgumentException(message);
                }
                Stack methodStack = (Stack)this.preceder.clone();
                methodStack.push(method);
                InvocationHandler<T> followHandler = new InvocationHandler<T>(this.callbackExport, this.delegate, this.remoteObjectIdentifier, methodStack);
                Object followProxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{method.getReturnType()}, followHandler);
                this.followMethods.put(method, followProxy);
            }
            ++n2;
        }
        this.proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.iface}, (java.lang.reflect.InvocationHandler)this);
    }

    public T getComponent() {
        return this.proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        if (this.ignoredMethods.contains(method)) {
            this.logger.info(String.format("Ignoring call to '%1$s.%2$s'.", this.iface.getSimpleName(), method.getName()));
            return null;
        }
        if (this.followMethods.containsKey(method)) {
            this.logger.info(String.format("Forwarding calls to '%1$s.%2$s'.", this.iface.getSimpleName(), method.getName()));
            return this.followMethods.get(method);
        }
        this.logger.info(String.format("Sending a message for '%1$s.%2$s'.", this.iface.getSimpleName(), method.getName()));
        Stack methodStack = (Stack)this.preceder.clone();
        methodStack.push(method);
        LinkedList<Object> callbackObjectsToDeregister = new LinkedList<Object>();
        int parameterPos = CommunicationHelperTools.checkMethodForCallback(method);
        if (parameterPos >= 0) {
            Class<?> callbackInterface = method.getParameterTypes()[parameterPos];
            Object object = args[parameterPos];
            URI callbackURI = null;
            if (object != null) {
                ProxyCallback annotation = callbackInterface.getAnnotation(ProxyCallback.class);
                if (!annotation.oneShot()) {
                    if (method.isAnnotationPresent(RegisterCallback.class)) {
                        callbackURI = this.callbackExport.exportCallback(callbackInterface, object);
                    } else if (method.isAnnotationPresent(DeregisterCallback.class)) {
                        callbackURI = this.callbackExport.getCallbackURIForObject(object);
                        callbackObjectsToDeregister.add(object);
                    }
                } else {
                    callbackURI = this.callbackExport.exportCallback(callbackInterface, object);
                }
                args[parameterPos] = callbackURI;
            }
        }
        try {
            result = this.delegate.invoke(this.remoteObjectIdentifier, methodStack, args);
        }
        catch (Throwable throwable) {
            StackTraceElement[] currentStackTrace = new Throwable().getStackTrace();
            StackTraceElement[] newStackTrace = StackTraceTools.join(throwable.getStackTrace(), 0, currentStackTrace, 2);
            throwable.setStackTrace(newStackTrace);
            throw throwable;
        }
        for (Object e : callbackObjectsToDeregister) {
            this.callbackExport.revokeCallbackExport(e);
        }
        return result;
    }
}

