/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.invocation;

import de.aristaflow.adept2.base.communication.CommunicationService;
import de.aristaflow.adept2.base.communication.Message;
import de.aristaflow.adept2.base.communication.annotations.ProxyAllow;
import de.aristaflow.adept2.base.communication.annotations.ProxyCallback;
import de.aristaflow.adept2.base.communication.annotations.ProxyCallbackKeepAlive;
import de.aristaflow.adept2.base.communication.invocation.CallbackInvocationMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationReplyMessage;
import de.aristaflow.adept2.base.communication.tools.CommunicationHelperTools;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.StackTraceTools;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InvocationMessage
extends Message {
    private static final long serialVersionUID = -3140750641838209832L;
    protected transient Logger logger = LoggerTools.getLogger(this);
    private final URI remoteObjectIdentifier;
    private Object usingObject;
    private Class<?> usingInterface;
    protected Stack<String> methodNames = new Stack();
    protected Class<?>[] parameterTypes;
    protected final Object[] parameters;
    protected Object result = null;
    protected Throwable exception = null;
    private final boolean isVoid;
    private double processingTime;
    private transient CommunicationService<?, ?, InvocationMessage, InvocationReplyMessage> communicationService;
    private final String version;

    public InvocationMessage(long messageID, URI remoteObjectIdentifier, Stack<Method> methodStack, Object[] parameters, String version) {
        super(messageID);
        if (remoteObjectIdentifier == null) {
            String message = "usingInstanceName must not be null.";
            this.logger.severe(message);
            throw new IllegalArgumentException(message);
        }
        this.remoteObjectIdentifier = remoteObjectIdentifier;
        if (methodStack == null || methodStack.size() == 0) {
            String message = "methodStack must not be null, its size must be > 0.";
            this.logger.severe(message);
            throw new IllegalArgumentException(message);
        }
        this.parameters = parameters == null ? new Object[0] : (Object[])parameters.clone();
        Method firstMethod = methodStack.peek();
        this.parameterTypes = firstMethod.getParameterTypes();
        this.isVoid = firstMethod.getReturnType() == Void.class;
        while (!methodStack.isEmpty()) {
            Method method = methodStack.pop();
            this.methodNames.push(method.getName());
        }
        this.version = version;
    }

    public void setUsingObjects(Object usingObject, Class<?> usingInterface) {
        if (usingObject == null) {
            String message = "usingObject must not be null.";
            this.logger.severe(message);
            throw new IllegalArgumentException(message);
        }
        this.usingObject = usingObject;
        if (usingInterface == null) {
            String message = "usingObject must not be null.";
            this.logger.severe(message);
            throw new IllegalArgumentException(message);
        }
        this.usingInterface = usingInterface;
    }

    public void setCommunicationService(CommunicationService<?, ?, InvocationMessage, InvocationReplyMessage> communicationService) {
        this.communicationService = communicationService;
    }

    public URI getRemoteObjectIdentifier() {
        return this.remoteObjectIdentifier;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean process() {
        invocationTime = 0L;
        this.logger = LoggerTools.getLogger(this);
        if (this.usingObject == null || this.usingInterface == null || this.communicationService == null) {
            message = "setUsingObjects(Object, Class) and setCommunicationService(communicationService) must be called, before process() is called.";
            this.logger.severe(message);
            throw new IllegalArgumentException(message);
        }
        tempResult = this.usingObject;
        iface = this.usingInterface;
        methodStack = (Stack)this.methodNames.clone();
        while (!methodStack.isEmpty()) {
            methodName = (String)methodStack.pop();
            this.logger.finer(String.format("Getting method '%1$s' from interface '%2$s'", new Object[]{methodName, iface}));
            try {
                if (methodStack.isEmpty()) {
                    method = this.searchForMethod(iface, methodName, this.parameterTypes);
                    if (this instanceof CallbackInvocationMessage && iface.getAnnotation(ProxyCallback.class).oneShot() && !method.isAnnotationPresent(ProxyCallbackKeepAlive.class)) {
                        callbackExport = this.communicationService.getADEPT2CallbackExport();
                        callbackExport.revokeCallbackExport(tempResult);
                    }
                    if ((parameterPos = CommunicationHelperTools.checkMethodForCallback(method)) >= 0 && (uri = (URI)this.parameters[parameterPos]) != null) {
                        callbackStubFactory = this.communicationService.getADEPT2CallbackStubFactory();
                        this.parameters[parameterPos] = callbackStubFactory.getServiceStub(uri, method.getParameterTypes()[parameterPos]);
                    }
                    invocationTime = System.nanoTime();
                    tempResult = method.invoke(tempResult, this.parameters);
                    continue;
                }
                method = this.searchForMethod(iface, methodName, new Class[0]);
                tempResult = method.invoke(tempResult, new Object[0]);
                iface = method.getReturnType();
                continue;
            }
            catch (SecurityException e) {
                message = String.format("Security exception occurred getting method '%1$s.%2$s' (implementation '%3$s').", new Object[]{iface.getSimpleName(), methodName, tempResult.getClass().getName()});
                this.logger.log(Level.SEVERE, message, e);
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                message = String.format("No such method exception occurred getting method '%1$s.%2$s' (implementation '%3$s').", new Object[]{iface.getSimpleName(), methodName, tempResult.getClass().getName()});
                this.logger.log(Level.SEVERE, message, e);
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                message = String.format("Illegal argument exception while calling '%1$s.%2$s' (implementation '%3$s').", new Object[]{iface.getSimpleName(), methodName, tempResult.getClass().getName()});
                this.logger.log(Level.SEVERE, message, e);
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                message = String.format("Illegal argument exception while calling '%1$s.%2$s' (implementation '%3$s').", new Object[]{iface.getSimpleName(), methodName, tempResult.getClass().getName()});
                this.logger.log(Level.SEVERE, message, e);
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                message = String.format("Invocation target exception while calling '%1$s.%2$s' (implementation '%3$s'). This may not be an error at all, but wanted.", new Object[]{iface.getSimpleName(), methodName, tempResult.getClass().getName()});
                this.logger.log(Level.INFO, message, e);
                this.exception = e.getCause();
                if (this.exception instanceof VirtualMachineError) {
                    errorMessage = String.format("A virtual machine error occurred while processing '%1$s.%2$s' (implementation '%3$s').", new Object[]{iface.getSimpleName(), methodName, tempResult.getClass().getName()});
                    this.logger.log(Level.SEVERE, errorMessage, this.exception);
                }
                if (this.exception instanceof InternalServiceException) {
                    msg = String.format("An InternalServiceException occurred while processing '%s.%s' (implementation '%s'", new Object[]{iface.getSimpleName(), methodName, tempResult.getClass().getName()});
                    this.logger.log(Level.SEVERE, msg, this.exception);
                }
                if (this.exception instanceof NullPointerException) {
                    msg = String.format("An NullPointerException occurred while processing '%s.%s' (implementation '%s'", new Object[]{iface.getSimpleName(), methodName, tempResult.getClass().getName()});
                    this.logger.log(Level.WARNING, msg, this.exception);
                }
                if (suppressStackTraces = false) {
                    this.exception.setStackTrace(new StackTraceElement[]{new StackTraceElement("***", "***", "server-side stack trace hidden", -1)});
                    break;
                }
                exceptionStackTrace = this.exception.getStackTrace();
                currentStackTraceHeight = new Throwable().getStackTrace().length;
                i = exceptionStackTrace.length - currentStackTraceHeight - 1;
                ** while (i >= 0)
            }
lbl-1000:
            // 1 sources

            {
                if (exceptionStackTrace[i].getMethodName().equals(methodName)) break;
                --i;
                continue;
            }
lbl69:
            // 2 sources

            tailTrim = exceptionStackTrace.length - (i + 1);
            if (tailTrim >= exceptionStackTrace.length) break;
            this.exception.setStackTrace(StackTraceTools.tailTrim(exceptionStackTrace, tailTrim));
            break;
        }
        this.processingTime = (double)(System.nanoTime() - invocationTime) / 1000000.0;
        this.result = tempResult;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private Method searchForMethod(Class<?> typeToScan, String nameOfMethodToSearchFor, Class<?>[] methodParameterTypes) throws SecurityException, NoSuchMethodException {
        block7: {
            method = null;
            try {
                method = typeToScan.getDeclaredMethod(nameOfMethodToSearchFor, methodParameterTypes);
                break block7;
            }
            catch (NoSuchMethodException e) {
                var9_6 = typeToScan.getInterfaces();
                var8_7 = var9_6.length;
                var7_8 = 0;
                ** while (var7_8 < var8_7)
            }
lbl-1000:
            // 1 sources

            {
                siface = var9_6[var7_8];
                infoMessage = String.format("Method '%s' in type '%s' not found, search within supertype '%s'.", new Object[]{nameOfMethodToSearchFor, typeToScan, siface});
                this.logger.info(infoMessage);
                try {
                    method = this.searchForMethod(siface, nameOfMethodToSearchFor, methodParameterTypes);
                    if (siface.isAnnotationPresent(ProxyAllow.class)) break;
                    warningMessage = String.format("Super type '%s' of type '%s', in which the requested method '%s' is found, is not annotated with ProxyAllow! ", new Object[]{siface, typeToScan, nameOfMethodToSearchFor});
                    this.logger.info(warningMessage);
                    break;
                }
                catch (SecurityException se) {
                    warningMessage = String.format("A SecurityException was thrown when trying to access super type '%s' of type '%s'! Ignoring type '%s'!", new Object[]{siface, typeToScan, siface});
                    this.logger.log(Level.WARNING, warningMessage, se);
                }
                catch (NoSuchMethodException v0) {
                    infoMessage = String.format("Method '%s' in super type '%s' of type '%s' not found!.", new Object[]{nameOfMethodToSearchFor, siface, typeToScan});
                    this.logger.info(infoMessage);
                }
                ++var7_8;
                continue;
            }
lbl28:
            // 3 sources

            if (method == null) {
                throw e;
            }
        }
        return method;
    }

    @Override
    public InvocationReplyMessage generateReplyMessage(long replyMessageID) {
        this.logger.info(String.format("Generating reply message (with ID '%5$s') for '%1$s:::%2$s', value '%3$s', exception '%4$s'.", this.remoteObjectIdentifier, this.methodNames.firstElement(), this.result, this.exception, replyMessageID));
        if (this.exception != null) {
            return new InvocationReplyMessage(replyMessageID, this.messageID, this.exception, this.processingTime);
        }
        if (this.isVoid) {
            return new InvocationReplyMessage(replyMessageID, this.messageID, this.processingTime);
        }
        return new InvocationReplyMessage(replyMessageID, this.messageID, this.result, this.processingTime);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.logger = LoggerTools.getLogger(this);
    }

    @Override
    public String toString() {
        String returnString = String.format("%s [id = '%s', ROI = '%s', methodNames = '%s']", this.getClass().getSimpleName(), this.messageID, this.remoteObjectIdentifier, this.methodNames);
        return returnString;
    }

    public String getVersion() {
        return this.version;
    }
}

