/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.invocation;

import de.aristaflow.adept2.base.communication.ADEPT2CallbackExport;
import de.aristaflow.adept2.base.communication.CallbackObjectNotRegistered;
import de.aristaflow.adept2.base.communication.CommunicationService;
import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.communication.CommunicationStackTerminator;
import de.aristaflow.adept2.base.communication.invocation.CallbackInvocationMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationReplyMessage;
import java.net.InetAddress;
import java.net.URI;

public class InvocationSkeleton
extends CommunicationStackTerminator<InvocationMessage, InvocationReplyMessage> {
    private final CommunicationService<?, ?, InvocationMessage, InvocationReplyMessage> communicationService;
    private long nextMessageID = 0L;
    private final String version;

    public InvocationSkeleton(CommunicationService<?, ?, InvocationMessage, InvocationReplyMessage> communicationService, String version) {
        this.communicationService = communicationService;
        this.version = version;
    }

    @Override
    public InvocationReplyMessage processInputAndReturn(URI remoteObjectIdentifier, InvocationMessage input) throws CommunicationStackException {
        InvocationMessage message = input;
        if (message.getVersion() == null || this.version == null || !message.getVersion().equals(this.version)) {
            throw new CommunicationStackException("Version mismatch! Your applications do not have the same/required version!");
        }
        this.logger.fine("MessageHandler: Processes message with id " + message.getMessageID() + ".");
        this.setMessageProcessor(message);
        message.process();
        InvocationReplyMessage replyMessage = message.generateReplyMessage(this.generateMessageID());
        if (replyMessage != null) {
            InetAddress receiverIP = message.getSenderIP();
            int receiverPort = message.getSenderPort();
            replyMessage.setMessageSender(receiverIP, receiverPort);
            return replyMessage;
        }
        throw new CommunicationStackException("No reply message specified!");
    }

    private synchronized long generateMessageID() {
        return this.nextMessageID++;
    }

    private void setMessageProcessor(InvocationMessage invocationMessage) throws CommunicationStackException {
        Object usingObject = null;
        Class<?> usingInterface = null;
        if (invocationMessage instanceof CallbackInvocationMessage) {
            CallbackInvocationMessage callbackMessage = (CallbackInvocationMessage)invocationMessage;
            URI callbackURI = callbackMessage.getCallbackURI();
            ADEPT2CallbackExport callbackExport = this.communicationService.getADEPT2CallbackExport();
            boolean isRegisteredCallbackURI = callbackExport.isRegisteredCallbackURI(callbackURI);
            if (isRegisteredCallbackURI) {
                usingObject = callbackExport.getCallbackObject(callbackURI);
                usingInterface = callbackExport.getCallbackInterface(callbackURI);
            }
            if (!isRegisteredCallbackURI || usingObject == null || usingInterface == null) {
                String warningMessage = String.format("Cannot process callback message '%s', No callback object for callback identifier '%s' registered yet or any longer!", callbackMessage, callbackURI);
                this.logger.info(warningMessage);
                throw new CallbackObjectNotRegistered(warningMessage, callbackURI);
            }
        } else {
            usingInterface = this.communicationService.getADEPT2ServiceExport().getRemoteInterfaceForExportedService(invocationMessage.getRemoteObjectIdentifier());
            usingObject = this.communicationService.getADEPT2ServiceExport().getExportedService(invocationMessage.getRemoteObjectIdentifier());
            if (usingObject == null || usingInterface == null) {
                String errorMessage = String.format("Remote service identified by '%s' cannot be found!", invocationMessage.getRemoteObjectIdentifier());
                this.logger.severe(errorMessage);
                throw new CommunicationStackException(errorMessage);
            }
        }
        invocationMessage.setUsingObjects(usingObject, usingInterface);
        invocationMessage.setCommunicationService(this.communicationService);
    }

    @Override
    protected void shutdownStackLayer() {
    }
}

