/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.invocation;

import de.aristaflow.adept2.base.communication.ADEPT2CommunicationStackFactory;
import de.aristaflow.adept2.base.communication.ADEPT2StubFactory;
import de.aristaflow.adept2.base.communication.CommunicationService;
import de.aristaflow.adept2.base.communication.CommunicationStack;
import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.communication.ServiceConnectionException;
import de.aristaflow.adept2.base.communication.invocation.CallbackInvocationMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationDelegate;
import de.aristaflow.adept2.base.communication.invocation.InvocationHandler;
import de.aristaflow.adept2.base.communication.invocation.InvocationMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationReplyMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationStubFactory;
import de.aristaflow.adept2.base.service.ADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Stack;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public class InvocationStub
extends AbstractADEPT2Service
implements InvocationDelegate {
    private long nextMessageID = 0L;
    private final String version;
    final CommunicationService<?, ?, InvocationMessage, InvocationReplyMessage> communicationService;

    public InvocationStub(Configuration configuration, Registry registry, CommunicationService<?, ?, InvocationMessage, InvocationReplyMessage> communicationService, String version) {
        super(configuration, registry);
        this.communicationService = communicationService;
        this.version = version;
    }

    @Override
    public Object invoke(URI remoteObjectIdentifier, Stack<Method> methodStack, Object[] parameters) throws Throwable {
        InvocationReplyMessage reply;
        long invocationTime = System.nanoTime();
        Method method = methodStack.peek();
        Method[] methodArray = Object.class.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.equals(method)) {
                this.logger.finer("The call to " + remoteObjectIdentifier + "." + method.getName() + "(...) will not be forwarded");
                return method.invoke((Object)new DummyObject(remoteObjectIdentifier), parameters);
            }
            ++n2;
        }
        long messageID = this.generateMessageID();
        ADEPT2StubFactory<Object> callbackStubFactory = this.communicationService.getADEPT2CallbackStubFactory();
        InvocationMessage message = callbackStubFactory.isStubCached(remoteObjectIdentifier) ? new CallbackInvocationMessage(messageID, remoteObjectIdentifier, methodStack, parameters, remoteObjectIdentifier, this.version) : new InvocationMessage(messageID, remoteObjectIdentifier, methodStack, parameters, this.version);
        ADEPT2CommunicationStackFactory<?, ?, InvocationMessage, InvocationReplyMessage> communicationStackFactory = this.communicationService.getADEPT2CommunicationStackFactory();
        CommunicationStack<InvocationMessage, InvocationReplyMessage> communicationPipe = communicationStackFactory.getStubCommunicationStack();
        try {
            reply = communicationPipe.process(remoteObjectIdentifier, message);
        }
        catch (CommunicationStackException e) {
            String errorMessage = String.format("An exception occured while processing message '%s':\n%s", message.toString(), e.getMessage());
            this.logger.log(Level.INFO, errorMessage, e);
            throw new ServiceConnectionException(errorMessage, e);
        }
        double messageTime = (double)(System.nanoTime() - invocationTime) / 1000000.0;
        String perfMessage = "PERF: Message time of message '%d: %s%s' was %,.3f ms, invocation time was %,.3f ms.";
        perfMessage = String.format(perfMessage, messageID, remoteObjectIdentifier, message.methodNames, messageTime, reply.getProcessingTime());
        this.logger.info(perfMessage);
        if (reply.getException() != null) {
            this.logger.log(Level.INFO, "Got an exception in the reply message ", reply.getException());
            throw reply.getException();
        }
        return reply.getReplyValue();
    }

    protected synchronized long generateMessageID() {
        return this.nextMessageID++;
    }

    private final class DummyObject {
        private final URI remoteObjectIdentifier;

        public DummyObject(URI remoteObjectIdentifier) {
            this.remoteObjectIdentifier = remoteObjectIdentifier;
        }

        public boolean equals(Object o) {
            if (o instanceof Proxy) {
                InvocationHandler<?> invocationHandler = this.getInvocationHandler(this.remoteObjectIdentifier);
                if (invocationHandler != null) {
                    return Proxy.getInvocationHandler(o).equals(invocationHandler);
                }
                String errorMessage = String.format("No InvocationHandler registered for the given remoteObjectIdentifier '%s', returning false!", this.remoteObjectIdentifier);
                InvocationStub.this.logger.severe(errorMessage);
                throw new RuntimeException(errorMessage);
            }
            if (o != null) {
                InvocationStub.this.logger.warning("Equals called with another object than Proxy: " + o.getClass().getSimpleName());
            } else {
                InvocationStub.this.logger.warning("Equals called with null!");
            }
            return false;
        }

        public int hashCode() {
            InvocationHandler<?> invocationHandler = this.getInvocationHandler(this.remoteObjectIdentifier);
            if (invocationHandler == null) {
                String errorMessage = String.format("No InvocationHandler registered for the given remoteObjectIdentifier '%s', returning false!", this.remoteObjectIdentifier);
                InvocationStub.this.logger.severe(errorMessage);
                throw new RuntimeException(errorMessage);
            }
            return invocationHandler.hashCode();
        }

        public String toString() {
            return this.remoteObjectIdentifier.toString();
        }

        private InvocationHandler<?> getInvocationHandler(URI remoteObjectIdentifier) {
            InvocationHandler<?> invocationHandler = null;
            ADEPT2StubFactory<ADEPT2Service> serviceStubFactory = InvocationStub.this.communicationService.getADEPT2ServiceStubFactory();
            if (serviceStubFactory.isStubCached(remoteObjectIdentifier)) {
                invocationHandler = ((InvocationStubFactory)serviceStubFactory).getInvocationHandler(remoteObjectIdentifier);
            } else {
                ADEPT2StubFactory<Object> callbackStubFactory = InvocationStub.this.communicationService.getADEPT2CallbackStubFactory();
                if (callbackStubFactory.isStubCached(remoteObjectIdentifier)) {
                    invocationHandler = ((InvocationStubFactory)callbackStubFactory).getInvocationHandler(remoteObjectIdentifier);
                }
            }
            return invocationHandler;
        }
    }
}

