/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.invocation;

import de.aristaflow.adept2.base.communication.ADEPT2CallbackExport;
import de.aristaflow.adept2.base.communication.ADEPT2StubFactory;
import de.aristaflow.adept2.base.communication.CommunicationService;
import de.aristaflow.adept2.base.communication.invocation.InvocationDelegate;
import de.aristaflow.adept2.base.communication.invocation.InvocationHandler;
import de.aristaflow.adept2.base.communication.invocation.InvocationMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationReplyMessage;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public abstract class InvocationStubFactory<S>
implements ADEPT2StubFactory<S> {
    protected CommunicationService<?, ?, InvocationMessage, InvocationReplyMessage> communicationService;
    protected final Logger logger;
    final Map<URI, InvocationHandler<?>> invocationHandlers = new HashMap();

    public InvocationStubFactory(CommunicationService<?, ?, InvocationMessage, InvocationReplyMessage> communicationService) {
        this.communicationService = communicationService;
        this.logger = LoggerTools.getLogger(this);
    }

    @Override
    public synchronized <T extends S> T getServiceStub(URI remoteObjectIdentifier, Class<T> remoteInterface) {
        InvocationHandler<Object> handler;
        if (this.invocationHandlers.containsKey(remoteObjectIdentifier)) {
            handler = this.invocationHandlers.get(remoteObjectIdentifier);
        } else {
            this.checkRemoteInterfaceAgainstRemoteObjectIdentifier(remoteObjectIdentifier, remoteInterface);
            InvocationDelegate invocationDelegate = this.communicationService.getInvocationDelegate();
            ADEPT2CallbackExport callbackExport = this.communicationService.getADEPT2CallbackExport();
            handler = new InvocationHandler<T>(callbackExport, invocationDelegate, remoteObjectIdentifier, remoteInterface);
            this.invocationHandlers.put(remoteObjectIdentifier, handler);
        }
        return (T)handler.getComponent();
    }

    protected abstract <T extends S> void checkRemoteInterfaceAgainstRemoteObjectIdentifier(URI var1, Class<T> var2);

    @Override
    public synchronized boolean isStubCached(URI remoteObjectIdentifier) {
        return this.invocationHandlers.containsKey(remoteObjectIdentifier);
    }

    public synchronized InvocationHandler<?> getInvocationHandler(URI remoteObjectIdentifier) {
        return this.invocationHandlers.get(remoteObjectIdentifier);
    }
}

