/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.invocation;

import de.aristaflow.adept2.base.communication.ADEPT2RemoteObjectIdentifierFactory;
import de.aristaflow.adept2.base.communication.CommunicationService;
import de.aristaflow.adept2.base.communication.invocation.InvocationMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationReplyMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationStubFactory;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.registry.AbstractRegistry;
import de.aristaflow.adept2.base.service.ADEPT2Service;
import java.net.URI;

public class ServiceInvocationStubFactory
extends InvocationStubFactory<ADEPT2Service> {
    protected final AbstractRegistry registry;

    public ServiceInvocationStubFactory(AbstractRegistry registry, CommunicationService<?, ?, InvocationMessage, InvocationReplyMessage> communicationService) {
        super(communicationService);
        this.registry = registry;
    }

    @Override
    protected <T extends ADEPT2Service> void checkRemoteInterfaceAgainstRemoteObjectIdentifier(URI remoteObjectIdentifier, Class<T> remoteInterface) {
        Class<?> interfaceForComponentType;
        ADEPT2RemoteObjectIdentifierFactory roiFactory = this.communicationService.getADEPT2RemoteObjectIdentifierFactory();
        String remoteObjectInstanceName = roiFactory.getInstanceNameFromServiceURI(remoteObjectIdentifier);
        String remoteObjectComponentType = this.registry.getComponentType(remoteObjectInstanceName);
        try {
            interfaceForComponentType = this.registry.getInterfaceForComponentType(remoteObjectComponentType);
        }
        catch (ConfigurationException ce) {
            throw new IllegalArgumentException(ce);
        }
        if (!remoteInterface.isAssignableFrom(interfaceForComponentType)) {
            String message = String.format("The interface encoded in the URI '%s', does not match the interface given as type parameter ('%s')!", remoteObjectIdentifier, remoteInterface.getCanonicalName());
            this.logger.severe(message);
            throw new IllegalArgumentException(message);
        }
    }
}

