/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.local;

import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.communication.CommunicationStackTerminator;
import de.aristaflow.adept2.base.communication.Message;
import de.aristaflow.adept2.base.communication.invocation.InvocationMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationReplyMessage;
import de.aristaflow.adept2.base.communication.local.LocalMessage;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.locking.ObjectEqualityLockCount;
import de.aristaflow.adept2.util.locking.ObjectLockManager;
import de.aristaflow.adept2.util.locking.ThreadLock;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;

public class LocalClient
extends CommunicationStackTerminator<InvocationMessage, InvocationReplyMessage>
implements IoHandler {
    private long timeout;
    private static final int SHORT_TIMEOUT = 10000;
    private AtomicLong handlerCount;
    private final Map<Long, LocalResponseHandler> handlerCache;
    private final Map<String, IoSession> sessionCache;
    private final ExecutorService socketConnectorExecutor;
    private final ObjectLockManager<String, Thread> sessionCreation;

    public LocalClient(long timeout) {
        this.timeout = timeout;
        this.handlerCount = new AtomicLong(0L);
        this.handlerCache = new HashMap<Long, LocalResponseHandler>();
        this.sessionCache = new HashMap<String, IoSession>();
        this.socketConnectorExecutor = Executors.newCachedThreadPool(new Adept2ThreadFactory("LocalClientExecutor"));
        try {
            this.sessionCreation = new ObjectLockManager(ObjectEqualityLockCount.class, ThreadLock.class, "Mina session creation lock");
        }
        catch (InvocationTargetException ite) {
            String msg = "Can not instantiate object lock manager for synchronising creation of IO sessions. There were problems instantiating the lock count manager and/or the session locks.";
            this.logger.log(Level.SEVERE, msg, ite);
            throw new InternalServiceException(msg, ite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InvocationReplyMessage processInputAndReturn(URI remoteObjectIdentifier, InvocationMessage input) throws CommunicationStackException {
        InvocationReplyMessage output = null;
        long currentTimeout = this.timeout;
        long id = this.handlerCount.getAndIncrement();
        LocalResponseHandler responseHandler = new LocalResponseHandler();
        Map<Long, LocalResponseHandler> map = this.handlerCache;
        synchronized (map) {
            this.handlerCache.put(id, responseHandler);
        }
        IoSession session = this.getSessionForURI(remoteObjectIdentifier);
        String msg = String.format("Send request '%s' via session '%s'.", id, session);
        this.logger.fine(msg);
        session.write((Object)new LocalMessage(id, input));
        try {
            try {
                boolean valid = false;
                do {
                    try {
                        output = responseHandler.get(currentTimeout, TimeUnit.MILLISECONDS);
                        msg = String.format("Received response for request '%s'", id);
                        this.logger.fine(msg);
                        valid = true;
                    }
                    catch (InterruptedException ie) {
                        String errorMessage = String.format("Getting interrupted while waiting for response from '%s', reducing timeout to 10 seconds and continuing waiting.", remoteObjectIdentifier);
                        this.logger.log(Level.INFO, errorMessage, ie);
                        currentTimeout = 10000L;
                    }
                } while (!valid);
            }
            catch (ExecutionException e) {
                String errorMessage = String.format("Cannot get the response from '%s', an Exception occurred:\n%s", remoteObjectIdentifier, e.getMessage());
                this.logger.log(Level.WARNING, errorMessage, e.getCause());
                throw new CommunicationStackException(errorMessage, e.getCause());
            }
            catch (TimeoutException e) {
                Object errorMessage = this.handlerCache;
                synchronized (errorMessage) {
                    this.handlerCache.remove(id);
                }
                output = responseHandler.getResult();
                if (output == null) {
                    errorMessage = String.format("Cannot get the response from '%s', the timeout of '%s' [ms] elapsed!", remoteObjectIdentifier, this.timeout);
                    this.logger.log(Level.WARNING, (String)errorMessage, e);
                    throw new CommunicationStackException((String)errorMessage, e);
                }
                if (currentTimeout == 10000L) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            if (currentTimeout == 10000L) {
                Thread.currentThread().interrupt();
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IoSession getSessionForURI(URI remoteObjectIdentifier) throws CommunicationStackException {
        boolean createSession;
        String key;
        IoSession session;
        block20: {
            session = null;
            String endpointHost = remoteObjectIdentifier.getHost();
            int endpointPort = remoteObjectIdentifier.getPort();
            if (endpointPort < 0) {
                String errorMessage = String.format("Error: RemoteObjectIdentifier '%s' does not specify the required target communication port! Going to cancel communication!", remoteObjectIdentifier);
                this.logger.severe(errorMessage);
                throw new CommunicationStackException(errorMessage);
            }
            key = endpointHost.concat(":" + endpointPort).intern();
            createSession = false;
            try {
                Map<String, IoSession> map = this.sessionCache;
                synchronized (map) {
                    if (this.sessionCache.containsKey(key) && this.sessionCache.get(key).isConnected()) {
                        session = this.sessionCache.get(key);
                    } else {
                        while (!createSession) {
                            try {
                                this.sessionCreation.getLockForObject(true, Thread.currentThread(), key);
                                createSession = true;
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                                String msg = String.format("Interrupted while retrieving lock for the creation of an IO session for '%s'. Aborting.", key);
                                throw new CommunicationStackException(msg, ie);
                            }
                        }
                    }
                }
                if (!createSession) break block20;
                ByteBuffer.setUseDirectBuffers((boolean)false);
                ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
                VmPipeConnector connector = new VmPipeConnector();
                ConnectFuture future = connector.connect((SocketAddress)new VmPipeAddress(endpointPort), (IoHandler)this);
                this.logger.info("Created new VM pipe session/connected to port " + endpointPort);
                boolean writeSuccessful = false;
                boolean interrupted = false;
                while (true) {
                    if (writeSuccessful) {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                        session = future.getSession();
                        this.sessionCache.put(key, session);
                        break;
                    }
                    try {
                        future.await();
                        writeSuccessful = true;
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                    }
                }
            }
            catch (Throwable throwable) {
                if (!createSession) throw throwable;
                try {
                    this.sessionCreation.unlockObject(true, Thread.currentThread(), key);
                    throw throwable;
                }
                catch (LockException le) {
                    String msg = String.format("Could not release session-creation-lock for key '%s'. This is a serious problem since we have locked it recently. However the creation was successful.", key);
                    this.logger.log(Level.SEVERE, msg, le);
                }
                throw throwable;
            }
        }
        if (!createSession) return session;
        try {
            this.sessionCreation.unlockObject(true, Thread.currentThread(), key);
            return session;
        }
        catch (LockException le) {
            String msg = String.format("Could not release session-creation-lock for key '%s'. This is a serious problem since we have locked it recently. However the creation was successful.", key);
            this.logger.log(Level.SEVERE, msg, le);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shutdownStackLayer() {
        Map<Object, Object> map = this.sessionCache;
        synchronized (map) {
            for (IoSession session : this.sessionCache.values()) {
                session.close();
                String msg = String.format("LocalClient closed session '%s'.", session);
                this.logger.finer(msg);
            }
            for (IoSession session : this.sessionCache.values()) {
                session.getCloseFuture().join();
            }
            this.sessionCache.clear();
        }
        map = this.handlerCache;
        synchronized (map) {
            this.handlerCache.clear();
        }
        this.socketConnectorExecutor.shutdown();
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        System.err.println("LocalClient.exceptionCaught");
        String msg = String.format("LocalClient caught an exception for session '%s'.", session);
        this.logger.log(Level.WARNING, msg, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoSession session, Object message) throws Exception {
        if (message instanceof LocalMessage) {
            LocalResponseHandler handler;
            String msg;
            LocalMessage mm = (LocalMessage)message;
            Map<Long, LocalResponseHandler> map = this.handlerCache;
            synchronized (map) {
                msg = String.format("The LocalClient received a message with the ID '%s'.", mm.getID());
                this.logger.finest(msg);
                handler = this.handlerCache.remove(mm.getID());
            }
            if (handler == null) {
                msg = String.format("The response handler for request '%s' is missing! Timeout reached?", mm.getID());
                this.logger.info(msg);
            } else {
                handler.setResult(mm.getMessage());
            }
        } else {
            String msg = String.format("Unexpected message type on client side: '%s' (expected: MinaMessage).", message.getClass());
            this.logger.severe(msg);
            throw new CommunicationStackException(msg);
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        if (message instanceof LocalMessage) {
            String msg = String.format("The LocalClient sent a message with the ID '%s'.", ((LocalMessage)message).getID());
            this.logger.finest(msg);
        } else {
            String msg = String.format("The LocalClient sent a message with an unexpected message type (%s)!", message.getClass().getName());
            this.logger.severe(msg);
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        String msg = String.format("The session (%s) was closed on client side!", session);
        this.logger.info(msg);
    }

    public void sessionCreated(IoSession session) throws Exception {
        String msg = String.format("The session (%s) was created on client side!", session);
        this.logger.fine(msg);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        String msg = String.format("The session (%s) is idle/in status (%s) on client side.", session, status);
        this.logger.finer(msg);
    }

    public void sessionOpened(IoSession session) throws Exception {
        String msg = String.format("The session (%s) was opened on client side!", session);
        this.logger.fine(msg);
    }

    private static class LocalResponseHandler
    implements Future<InvocationReplyMessage> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private InvocationReplyMessage result;

        public void setResult(Message result) {
            if (!(result instanceof InvocationReplyMessage)) {
                throw new RuntimeException("Unknown result type!");
            }
            this.result = (InvocationReplyMessage)result;
            this.latch.countDown();
        }

        public InvocationReplyMessage getResult() {
            return this.result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public InvocationReplyMessage get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public InvocationReplyMessage get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.latch.await(timeout, unit)) {
                throw new TimeoutException("Unknown reason! " + timeout);
            }
            return this.result;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }
    }
}

