/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.local;

import de.aristaflow.adept2.base.communication.CommunicationStack;
import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.communication.Message;
import de.aristaflow.adept2.base.communication.communicationservices.LocalCommunicationService;
import de.aristaflow.adept2.base.communication.invocation.InvocationMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationReplyMessage;
import de.aristaflow.adept2.base.communication.local.LocalMessage;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;

public class LocalServer
extends AbstractSubService
implements IoHandler {
    private int port;
    private final LocalCommunicationService communicationService;
    private final ExecutorService socketAcceptorExecutor;
    private final ExecutorService serverPool;
    private IoAcceptor acceptor;

    public LocalServer(LocalCommunicationService communicationService, int port) {
        super(communicationService);
        this.port = port;
        this.communicationService = communicationService;
        this.socketAcceptorExecutor = Executors.newCachedThreadPool(new Adept2ThreadFactory("LocalServerExecutor"));
        this.serverPool = Executors.newCachedThreadPool(new Adept2ThreadFactory("LocalServerPool"));
    }

    @Override
    public void init() throws ConfigurationException {
        block6: {
            ByteBuffer.setUseDirectBuffers((boolean)false);
            ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
            this.acceptor = new VmPipeAcceptor();
            try {
                this.acceptor.bind((SocketAddress)new VmPipeAddress(this.port), (IoHandler)this);
                if (this.acceptor.getManagedServiceAddresses().size() == 1) {
                    SocketAddress addr = (SocketAddress)this.acceptor.getManagedServiceAddresses().iterator().next();
                    if (addr instanceof InetSocketAddress) {
                        this.port = ((InetSocketAddress)addr).getPort();
                    } else if (addr instanceof VmPipeAddress) {
                        this.port = ((VmPipeAddress)addr).getPort();
                    }
                    break block6;
                }
                throw new InternalServiceException("Unable to get the port from the IoAcceptor!");
            }
            catch (IOException e) {
                throw new ConfigurationException("The server socket (skeleton) could not be started, because port '" + this.port + "' is already in use. (" + e.toString() + ") " + "Change the port in the configuration" + " (ADEPT2.properties) and try again!");
            }
        }
        String msg = String.format("MINA VM pipe server started on port '%s'.", this.port);
        this.logger.info(msg);
    }

    @Override
    public void shutdown() {
        this.serverPool.shutdown();
        this.socketAcceptorExecutor.shutdown();
        LocalServer.awaitExecutorServiceShutdown(this.serverPool);
        LocalServer.awaitExecutorServiceShutdown(this.socketAcceptorExecutor);
        this.logger.info("Shutdown succeeded!");
    }

    @Override
    public void emergencyShutdown() {
        this.serverPool.shutdownNow();
        this.socketAcceptorExecutor.shutdownNow();
        LocalServer.awaitExecutorServiceShutdown(this.serverPool);
        LocalServer.awaitExecutorServiceShutdown(this.socketAcceptorExecutor);
    }

    private static void awaitExecutorServiceShutdown(ExecutorService service) {
        boolean terminated = false;
        while (!terminated) {
            try {
                terminated = service.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getPort() {
        return this.port;
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        System.err.println("LocalServer.exceptionCaught");
        String msg = String.format("LocalServer caught an exception for session '%s'.", session);
        this.logger.log(Level.WARNING, msg, cause);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (!(message instanceof LocalMessage)) {
            String msg = String.format("Unexpected message type on server side: '%s' (expected: MinaMessage).", message.getClass());
            this.logger.severe(msg);
            throw new CommunicationStackException(msg);
        }
        LocalMessage mm = (LocalMessage)message;
        String msg = String.format("The LocalServer received a message with the ID '%s'.", mm.getID());
        this.logger.finest(msg);
        this.serverPool.execute(new LocalRequestHandler(mm.getID(), mm.getMessage(), session, this.communicationService.getSkeletonCommunicationStack()));
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        if (message instanceof LocalMessage) {
            String msg = String.format("The LocalServer sent a message with the ID '%s'.", ((LocalMessage)message).getID());
            this.logger.finest(msg);
        } else {
            String msg = String.format("The LocalServer sent a message with an unexpected message type (%s)!", message.getClass().getName());
            this.logger.severe(msg);
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        String msg = String.format("The session (%s) was closed on server side!", session);
        this.logger.info(msg);
    }

    public void sessionCreated(IoSession session) throws Exception {
        String msg = String.format("The session (%s) was created on server side!", session);
        this.logger.fine(msg);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        String msg = String.format("The session (%s) is idle/in status (%s) on server side.", session, status);
        this.logger.finer(msg);
    }

    public void sessionOpened(IoSession session) throws Exception {
        String msg = String.format("The session (%s) was opened on server side!", session);
        this.logger.fine(msg);
    }

    private static class LocalRequestHandler
    implements Runnable {
        private final long id;
        private final InvocationMessage request;
        private final IoSession session;
        private final Logger logger = LoggerTools.getLogger(this);
        private final CommunicationStack<InvocationMessage, InvocationReplyMessage> communicationStack;

        public LocalRequestHandler(long id, Message request, IoSession session, CommunicationStack<InvocationMessage, InvocationReplyMessage> communicationStack) throws CommunicationStackException {
            this.id = id;
            if (!(request instanceof InvocationMessage)) {
                String msg = "Unexpected request message type: " + request.getClass();
                this.logger.warning(msg);
                throw new CommunicationStackException(msg);
            }
            this.request = (InvocationMessage)request;
            this.session = session;
            this.communicationStack = communicationStack;
        }

        @Override
        public void run() {
            try {
                InvocationReplyMessage message = this.communicationStack.process(null, this.request);
                String msg = String.format("The request handler processed message with id '%s' for session '%s'.", this.id, this.session);
                this.logger.fine(msg);
                LocalMessage minaMessage = new LocalMessage(this.id, message);
                this.session.write((Object)minaMessage);
            }
            catch (CommunicationStackException e) {
                String msg = "A CommunicationStackException occured during processing and answering a request.";
                this.logger.log(Level.SEVERE, msg, e);
                throw new InternalServiceException(msg, e);
            }
        }
    }
}

