/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.mina;

import de.aristaflow.adept2.base.communication.communicationservices.AbstractMinaCommunicationService;
import de.aristaflow.adept2.base.communication.mina.AbstractMinaCommunicator;
import de.aristaflow.adept2.base.communication.mina.MinaMessage;
import de.aristaflow.adept2.base.communication.mina.MinaResponseHandler;
import de.aristaflow.adept2.base.communication.mina.ProtocolDecoderException;
import de.aristaflow.adept2.base.communication.mina.ProtocolEncoderException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.socket.nio.SocketConnector;

public abstract class AbstractMinaClient<I, O>
extends AbstractMinaCommunicator<I, O> {
    private final Set<SocketConnector> connectors = new HashSet<SocketConnector>();

    public AbstractMinaClient(long timeout, boolean useSSL, String sslCertFileName, String sslKeystorePass, String name, String clientID) {
        super(timeout, useSSL, sslCertFileName, sslKeystorePass, name, clientID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(IoSession session, Throwable cause) {
        MinaMessage<?> mm = null;
        if (cause instanceof ProtocolDecoderException) {
            mm = ((ProtocolDecoderException)((Object)cause)).getMinaMessage();
        } else if (cause instanceof ProtocolEncoderException) {
            mm = ((ProtocolEncoderException)((Object)cause)).getMinaMessage();
        }
        if (mm != null) {
            MinaResponseHandler handler;
            String msg;
            Map map = this.handlerIDCache;
            synchronized (map) {
                msg = String.format("The MinaClient caught an exception for the message ID '%s'.", mm.getID());
                this.logger.finest(msg);
                handler = (MinaResponseHandler)this.handlerIDCache.remove(mm.getID());
            }
            if (handler != null) {
                handler.setThrowable(cause);
            } else {
                msg = String.format("The response handler for request '%s' is missing! Timeout reached?", mm.getID());
                this.logger.info(msg);
            }
        } else {
            MinaResponseHandler handler;
            Map map = this.handlerIDCache;
            synchronized (map) {
                handler = (MinaResponseHandler)this.handlerThreadCache.get();
            }
            if (handler != null) {
                handler.setThrowable(cause);
            } else {
                String msg = String.format("'%s' caught an exception for session '%s'. The corresponding handler could not be retrieved.", this.name, session);
                this.logger.log(Level.SEVERE, msg, cause);
            }
        }
    }

    @Override
    protected IoConnector createSocketConnector() {
        SocketConnector ret = new SocketConnector(3, (Executor)this.socketConnectorExecutor);
        this.connectors.add(ret);
        return ret;
    }

    @Override
    protected void shutdownStackLayer() {
        super.shutdownStackLayer();
        for (SocketConnector con : this.connectors) {
            con.setWorkerTimeout(5);
        }
        AbstractMinaCommunicationService.awaitExecutorServiceShutdown(this.socketConnectorExecutor);
    }
}

