/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.mina;

import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.communication.CommunicationStackTerminator;
import de.aristaflow.adept2.base.communication.mina.MinaMessage;
import de.aristaflow.adept2.base.communication.mina.MinaResponseHandler;
import de.aristaflow.adept2.base.configuration.SystemProperties;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.locking.ObjectEqualityLockCount;
import de.aristaflow.adept2.util.locking.ObjectLockManager;
import de.aristaflow.adept2.util.locking.ThreadLock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.UnresolvedAddressException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;

public abstract class AbstractMinaCommunicator<I, O>
extends CommunicationStackTerminator<I, O>
implements IoHandler {
    protected long timeout;
    protected static final int SHORT_TIMEOUT = 10000;
    protected final boolean useSSL;
    protected final String sslCertFileName;
    protected final String sslKeystorePass;
    protected final String name;
    protected final String clientID;
    protected volatile long handlerCount;
    protected final Map<Long, MinaResponseHandler<O>> handlerIDCache;
    protected final ThreadLocal<MinaResponseHandler<O>> handlerThreadCache;
    protected final Map<String, IoSession> sessionCache;
    protected final ReadWriteLock sessionCacheLock;
    protected final ExecutorService socketConnectorExecutor;
    protected final ObjectLockManager<IoSession, Thread> sessionWriting;

    public AbstractMinaCommunicator(long timeout, boolean useSSL, String sslCertFileName, String sslKeystorePass, String name, String clientID) {
        this.timeout = timeout;
        this.useSSL = useSSL;
        this.sslCertFileName = sslCertFileName;
        this.sslKeystorePass = sslKeystorePass;
        this.name = name;
        this.clientID = clientID;
        this.handlerCount = 0L;
        this.handlerIDCache = new HashMap<Long, MinaResponseHandler<O>>();
        this.handlerThreadCache = new ThreadLocal();
        this.sessionCache = new HashMap<String, IoSession>();
        this.sessionCacheLock = new ReentrantReadWriteLock();
        this.socketConnectorExecutor = Executors.newCachedThreadPool(new Adept2ThreadFactory(String.valueOf(name) + "-ConnectorExecutor"));
        try {
            this.sessionWriting = new ObjectLockManager(ObjectEqualityLockCount.class, ThreadLock.class, "Mina session write lock");
        }
        catch (InvocationTargetException ite) {
            String msg = "Can not instantiate object lock manager for synchronising creation of IO sessions. There were problems instantiating the lock count manager and/or the session locks.";
            this.logger.log(Level.SEVERE, msg, ite);
            throw new InternalServiceException(msg, ite);
        }
    }

    protected abstract ProtocolCodecFactory getProtocolCodecFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected O processInputAndReturn(URI remoteObjectIdentifier, I input) throws CommunicationStackException {
        String errorMessage;
        O output = null;
        long id = -1L;
        MinaResponseHandler responseHandler = null;
        IoSession session = null;
        boolean locked = false;
        long currentTimeout = this.timeout;
        try {
            AbstractMinaCommunicator abstractMinaCommunicator = this;
            synchronized (abstractMinaCommunicator) {
                id = this.handlerCount++;
                responseHandler = new MinaResponseHandler();
                Map<Long, MinaResponseHandler<O>> map = this.handlerIDCache;
                synchronized (map) {
                    this.handlerIDCache.put(id, responseHandler);
                    this.handlerThreadCache.set(responseHandler);
                }
                session = this.getSessionForURI(remoteObjectIdentifier);
                try {
                    this.sessionWriting.getLockForObject(true, Thread.currentThread(), session);
                    locked = true;
                }
                catch (InterruptedException ie) {
                    output = (O)responseHandler.getResult();
                    Thread.currentThread().interrupt();
                    if (output == null) {
                        String errorMessage2 = String.format("Interrupted while waiting to lock the session '%s' for writing. Aborting sending the message (ID: %d)to '%s'.", session, id, remoteObjectIdentifier);
                        this.logger.log(Level.WARNING, errorMessage2, ie);
                        throw new CommunicationStackException(errorMessage2, ie);
                    }
                    O o = output;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 18, 25] lbl37 : MonitorExitStatement: MONITOREXIT : var12_9
                    Map<Long, MinaResponseHandler<O>> map2 = this.handlerIDCache;
                    synchronized (map2) {
                        this.handlerIDCache.remove(id);
                        if (this.handlerIDCache.isEmpty()) {
                            this.handlerIDCache.notifyAll();
                        }
                        this.handlerThreadCache.remove();
                    }
                    if (locked) {
                        try {
                            this.sessionWriting.unlockObject(true, Thread.currentThread(), session);
                        }
                        catch (LockException le) {
                            String msg = String.format("Could not release session-write-lock for session '%s' for sending request %d to '%s'. This is a serious problem since we have locked it  recently. Sending was successful but all further messages may be blocked.", session, id, remoteObjectIdentifier);
                            this.logger.log(Level.SEVERE, msg, le);
                        }
                    }
                    if (currentTimeout != 10000L) return o;
                    Thread.currentThread().interrupt();
                    return o;
                }
            }
        }
        catch (ExecutionException e) {
            errorMessage = String.format("Cannot get the response from '%s' for request '%s', an Exception occurred:\n%s", remoteObjectIdentifier, id, e.getMessage());
            this.logger.log(Level.INFO, errorMessage, e.getCause());
            throw new CommunicationStackException(errorMessage, e.getCause());
        }
        catch (TimeoutException e) {
            if (responseHandler != null) {
                output = (O)responseHandler.getResult();
            }
            if (output == null) {
                errorMessage = String.format("Cannot get the response from '%s' for request '%s', the timeout of '%s' [ms] elapsed!", remoteObjectIdentifier, id, this.timeout);
                this.logger.log(Level.INFO, errorMessage, e);
                throw new CommunicationStackException(errorMessage, e);
            }
            Map<Long, MinaResponseHandler<O>> le = this.handlerIDCache;
            synchronized (le) {
                this.handlerIDCache.remove(id);
                if (this.handlerIDCache.isEmpty()) {
                    this.handlerIDCache.notifyAll();
                }
                this.handlerThreadCache.remove();
            }
            if (locked) {
                try {
                    this.sessionWriting.unlockObject(true, Thread.currentThread(), session);
                }
                catch (LockException le2) {
                    String msg = String.format("Could not release session-write-lock for session '%s' for sending request %d to '%s'. This is a serious problem since we have locked it  recently. Sending was successful but all further messages may be blocked.", session, id, remoteObjectIdentifier);
                    this.logger.log(Level.SEVERE, msg, le2);
                }
            }
            if (currentTimeout != 10000L) return output;
            Thread.currentThread().interrupt();
            return output;
        }
        catch (Throwable throwable) {
            Map<Long, MinaResponseHandler<O>> le2 = this.handlerIDCache;
            synchronized (le2) {
                this.handlerIDCache.remove(id);
                if (this.handlerIDCache.isEmpty()) {
                    this.handlerIDCache.notifyAll();
                }
                this.handlerThreadCache.remove();
            }
            if (locked) {
                try {
                    this.sessionWriting.unlockObject(true, Thread.currentThread(), session);
                }
                catch (LockException le) {
                    String msg = String.format("Could not release session-write-lock for session '%s' for sending request %d to '%s'. This is a serious problem since we have locked it  recently. Sending was successful but all further messages may be blocked.", session, id, remoteObjectIdentifier);
                    this.logger.log(Level.SEVERE, msg, le);
                }
            }
            if (currentTimeout != 10000L) throw throwable;
            Thread.currentThread().interrupt();
            throw throwable;
        }
        String msg = String.format("Send request '%s' via session '%s'.", id, session);
        this.logger.fine(msg);
        WriteFuture write = session.write(new MinaMessage<I>(1, id, input));
        boolean writeSuccessful = false;
        boolean interrupted = false;
        while (true) {
            if (writeSuccessful) {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                try {
                    this.sessionWriting.unlockObject(true, Thread.currentThread(), session);
                    locked = false;
                }
                catch (LockException le) {
                    msg = String.format("Could not release session-write-lock for session '%s' for sending request %d to '%s'. This is a serious problem since we have locked it  recently. Sending was successful but all further messages may be blocked. We try to receive the corresponding response.", session, id, remoteObjectIdentifier);
                    this.logger.log(Level.SEVERE, msg, le);
                }
                break;
            }
            try {
                write.await();
                writeSuccessful = true;
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
            }
        }
        boolean valid = false;
        do {
            try {
                output = (O)responseHandler.get(currentTimeout, TimeUnit.MILLISECONDS);
                msg = String.format("Received response for request '%s'", id);
                this.logger.fine(msg);
                valid = true;
            }
            catch (InterruptedException ie) {
                String errorMessage3 = String.format("Getting interrupted while waiting for response from '%s', reducing timeout to %d seconds and continuing waiting.", remoteObjectIdentifier, 10);
                this.logger.log(Level.INFO, errorMessage3, ie);
                currentTimeout = 10000L;
            }
        } while (!valid);
        Map<Long, MinaResponseHandler<O>> le = this.handlerIDCache;
        synchronized (le) {
            this.handlerIDCache.remove(id);
            if (this.handlerIDCache.isEmpty()) {
                this.handlerIDCache.notifyAll();
            }
            this.handlerThreadCache.remove();
        }
        if (locked) {
            try {
                this.sessionWriting.unlockObject(true, Thread.currentThread(), session);
            }
            catch (LockException le3) {
                msg = String.format("Could not release session-write-lock for session '%s' for sending request %d to '%s'. This is a serious problem since we have locked it  recently. Sending was successful but all further messages may be blocked.", session, id, remoteObjectIdentifier);
                this.logger.log(Level.SEVERE, msg, le3);
            }
        }
        if (currentTimeout != 10000L) return output;
        Thread.currentThread().interrupt();
        return output;
    }

    protected IoSession getSessionForURI(URI remoteObjectIdentifier) throws CommunicationStackException {
        IoSession session;
        block30: {
            String endpointHost = remoteObjectIdentifier.getHost();
            int endpointPort = remoteObjectIdentifier.getPort();
            if (endpointPort < 0) {
                String errorMessage = String.format("Error: RemoteObjectIdentifier '%s' does not specify the required target communication port! Going to cancel communication!", remoteObjectIdentifier);
                this.logger.info(errorMessage);
                throw new CommunicationStackException(errorMessage);
            }
            String key = endpointHost.concat(":" + endpointPort).intern();
            this.sessionCacheLock.writeLock().lock();
            try {
                ConnectFuture future;
                if (this.sessionCache.containsKey(key) && this.sessionCache.get(key).isConnected()) {
                    session = this.sessionCache.get(key);
                    break block30;
                }
                ByteBuffer.setUseDirectBuffers((boolean)false);
                ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
                IoConnector connector = this.createSocketConnector();
                SocketConnectorConfig cfg = new SocketConnectorConfig();
                cfg.setThreadModel(ThreadModel.MANUAL);
                if (this.useSSL) {
                    FileInputStream fis = null;
                    try {
                        try {
                            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                            String fileDir = SystemProperties.getDataDir().concat(File.separator).concat(this.sslCertFileName);
                            fis = new FileInputStream(new File(fileDir));
                            keyStore.load(fis, this.sslKeystorePass.toCharArray());
                            fis.close();
                            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                            tmf.init(keyStore);
                            TrustManager[] trustManager = tmf.getTrustManagers();
                            SSLContext context = SSLContext.getInstance("SSL");
                            context.init(null, trustManager, new SecureRandom());
                            SSLFilter filter = new SSLFilter(context);
                            filter.setUseClientMode(true);
                            cfg.getFilterChain().addLast("sslFilter", (IoFilter)filter);
                        }
                        catch (KeyManagementException e) {
                            String msg = "A KeyManagementException occurred while trying to initialise the SSLContext.";
                            throw new CommunicationStackException(msg, e);
                        }
                        catch (KeyStoreException e) {
                            String msg = "A KeyStoreException occurred while trying to initialise the TrustManager.";
                            throw new CommunicationStackException(msg, e);
                        }
                        catch (FileNotFoundException e) {
                            String msg = "A FileNotFoundException occurred while trying to read the ssl certificate file.";
                            throw new CommunicationStackException(msg, e);
                        }
                        catch (NoSuchAlgorithmException e) {
                            String msg = "A NoSuchAlgorithmException occurred while trying to get the SSLContext from the TrustManager.";
                            throw new CommunicationStackException(msg, e);
                        }
                        catch (CertificateException e) {
                            String msg = "A CertificateException occurred while trying to load the ssl certificate into the key store.";
                            throw new CommunicationStackException(msg, e);
                        }
                        catch (IOException e) {
                            String msg = "An IOException occurred while trying to load the ssl certificate into the key store.";
                            throw new CommunicationStackException(msg, e);
                        }
                    }
                    finally {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (IOException e) {
                            String msg = "An IOException occurred while trying to close the FileInputStream used to read the ssl certificate.";
                            throw new CommunicationStackException(msg, e);
                        }
                    }
                }
                cfg.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter(this.getProtocolCodecFactory()));
                InetSocketAddress address = new InetSocketAddress(endpointHost, endpointPort);
                try {
                    future = connector.connect((SocketAddress)address, (IoHandler)this, (IoServiceConfig)cfg);
                }
                catch (UnresolvedAddressException uae) {
                    String msg = String.format("Could not resolve address '%s'. Aborting request", address);
                    throw new CommunicationStackException(msg, uae);
                }
                this.logger.info("Created new session/connected to " + address);
                boolean writeSuccessful = false;
                boolean interrupted = false;
                while (!writeSuccessful) {
                    try {
                        future.await();
                        writeSuccessful = true;
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                try {
                    session = future.getSession();
                }
                catch (RuntimeIOException e) {
                    String msg = String.format("Exception while trying to get the session for '%s'!", remoteObjectIdentifier);
                    throw new CommunicationStackException(msg, e);
                }
                if (this.clientID != null) {
                    session.write(new MinaMessage(0, this.clientID));
                }
                this.sessionCache.put(key, session);
            }
            finally {
                this.sessionCacheLock.writeLock().unlock();
            }
        }
        return session;
    }

    protected IoConnector createSocketConnector() {
        return new SocketConnector(3, (Executor)this.socketConnectorExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shutdownStackLayer() {
        HashSet<IoSession> sessions;
        Map<Long, MinaResponseHandler<O>> map = this.handlerIDCache;
        synchronized (map) {
            if (!this.handlerIDCache.isEmpty()) {
                boolean terminated = false;
                while (!terminated) {
                    try {
                        this.handlerIDCache.wait();
                        terminated = true;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        this.socketConnectorExecutor.shutdown();
        this.sessionCacheLock.readLock().lock();
        try {
            sessions = new HashSet<IoSession>(this.sessionCache.values());
        }
        finally {
            this.sessionCacheLock.readLock().unlock();
        }
        for (IoSession session : sessions) {
            session.close();
            String msg = String.format("%s closed session '%s'.", this.name, session);
            this.logger.finer(msg);
        }
        for (IoSession session : sessions) {
            session.getCloseFuture().join();
        }
        this.sessionCacheLock.writeLock().lock();
        try {
            this.sessionCache.clear();
        }
        finally {
            this.sessionCacheLock.writeLock().unlock();
        }
    }

    public abstract void exceptionCaught(IoSession var1, Throwable var2) throws CommunicationStackException;

    public abstract void messageReceived(IoSession var1, Object var2) throws CommunicationStackException;

    public void messageSent(IoSession session, Object message) throws CommunicationStackException {
        Level level;
        String msg;
        if (message instanceof MinaMessage) {
            MinaMessage mm = (MinaMessage)message;
            switch (mm.getType()) {
                case 0: {
                    msg = String.format("The %s sent a start message with the identifier '%s'", this.name, mm.getClientID());
                    level = Level.FINEST;
                    break;
                }
                case 1: {
                    msg = String.format("The %s sent a request message with the ID '%s'.", this.name, mm.getID());
                    level = Level.FINEST;
                    break;
                }
                case 2: {
                    msg = String.format("The %s sent a response message with the ID '%s'.", this.name, mm.getID());
                    level = Level.FINEST;
                    break;
                }
                case 3: {
                    msg = String.format("The %s sent an exceptional response message with the ID '%s'.", this.name, mm.getID());
                    level = Level.FINEST;
                    break;
                }
                default: {
                    msg = String.format("The %s sent a MinaMessage with an unexpected type (%s)", this.name, mm.getType());
                    level = Level.WARNING;
                    break;
                }
            }
        } else {
            msg = String.format("The %s sent a message with an unexpected message type (%s)!", this.name, message.getClass().getName());
            level = Level.FINE;
        }
        this.logger.log(level, msg);
    }

    public void sessionClosed(IoSession session) throws CommunicationStackException {
        String msg = String.format("The session (%s) was closed on side of '%s'!", session, this.name);
        this.logger.info(msg);
    }

    public void sessionCreated(IoSession session) throws CommunicationStackException {
        String msg = String.format("The session (%s) was created on side of '%s'!", session, this.name);
        this.logger.fine(msg);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws CommunicationStackException {
        String msg = String.format("The session (%s) is idle/in status (%s) on side of '%s'.", session, status, this.name);
        this.logger.finer(msg);
    }

    public void sessionOpened(IoSession session) throws CommunicationStackException {
        String msg = String.format("The session (%s) was opened on side of '%s'!", session, this.name);
        this.logger.fine(msg);
    }
}

