/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.mina;

import de.aristaflow.adept2.base.communication.communicationservices.AbstractMinaCommunicationService;
import de.aristaflow.adept2.base.communication.mina.AbstractMinaCommunicator;
import de.aristaflow.adept2.base.communication.mina.MinaMessage;
import de.aristaflow.adept2.base.communication.mina.ProtocolDecoderException;
import de.aristaflow.adept2.base.communication.mina.ProtocolEncoderException;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.SystemProperties;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;

public abstract class AbstractMinaServer<I, O>
extends AbstractMinaCommunicator<I, O> {
    protected final InetAddress serverHostIP;
    protected int port;
    protected final AbstractMinaCommunicationService<I, O> communicationService;
    protected final ExecutorService socketAcceptorExecutor;
    protected final ExecutorService serverPool;
    private IoAcceptor acceptor;

    public AbstractMinaServer(InetAddress serverHostIP, int port, long timeout, boolean useSSL, String sslCertFileName, String sslKeystorePass, String name, AbstractMinaCommunicationService<I, O> communicationService) {
        super(timeout, useSSL, sslCertFileName, sslKeystorePass, name, null);
        this.serverHostIP = serverHostIP;
        this.port = port;
        this.communicationService = communicationService;
        this.socketAcceptorExecutor = Executors.newCachedThreadPool(new Adept2ThreadFactory(String.valueOf(name) + "-AcceptorExecutor"));
        this.serverPool = Executors.newCachedThreadPool(new Adept2ThreadFactory(String.valueOf(name) + "ServerPool"));
    }

    public void init() throws ConfigurationException {
        ByteBuffer.setUseDirectBuffers((boolean)false);
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        try {
            this.acceptor = new SocketAcceptor(3, (Executor)this.socketAcceptorExecutor);
            SocketAcceptorConfig acceptorConfig = new SocketAcceptorConfig();
            acceptorConfig.setThreadModel(ThreadModel.MANUAL);
            if (this.useSSL) {
                FileInputStream fis = null;
                try {
                    try {
                        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                        String fileDir = SystemProperties.getDataDir().concat(File.separator).concat(this.sslCertFileName);
                        fis = new FileInputStream(new File(fileDir));
                        keyStore.load(fis, this.sslKeystorePass.toCharArray());
                        fis.close();
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        kmf.init(keyStore, this.sslKeystorePass.toCharArray());
                        KeyManager[] keyManager = kmf.getKeyManagers();
                        SSLContext context = SSLContext.getInstance("SSL");
                        context.init(keyManager, null, new SecureRandom());
                        SSLFilter filter = new SSLFilter(context);
                        filter.setUseClientMode(false);
                        acceptorConfig.getFilterChain().addLast("sslFilter", (IoFilter)filter);
                    }
                    catch (KeyManagementException e) {
                        String msg = "A KeyManagementException occurred while trying to initialise the SSLContext.";
                        throw new ConfigurationException(msg, e);
                    }
                    catch (KeyStoreException e) {
                        String msg = "A KeyStoreException occurred while trying to initialise the KeyManager.";
                        throw new ConfigurationException(msg, e);
                    }
                    catch (FileNotFoundException e) {
                        String msg = "A FileNotFoundException occurred while trying to read the ssl certificate file.";
                        throw new ConfigurationException(msg, e);
                    }
                    catch (NoSuchAlgorithmException e) {
                        String msg = "A NoSuchAlgorithmException occurred while trying to get the SSLContext from the KeyManager.";
                        throw new ConfigurationException(msg, e);
                    }
                    catch (CertificateException e) {
                        String msg = "A CertificateException occurred while trying to load the ssl certificate into the key store.";
                        throw new ConfigurationException(msg, e);
                    }
                    catch (UnrecoverableKeyException e) {
                        String msg = "An UnrecoverableKeyException occurred while trying to initialise the KeyManager.";
                        throw new ConfigurationException(msg, e);
                    }
                    catch (IOException e) {
                        String msg = "An IOException occurred while trying to load the ssl certificate into the key store.";
                        throw new ConfigurationException(msg, e);
                    }
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException e) {
                        String msg = "An IOException occurred while trying to close the FileInputStream used to read the ssl certificate.";
                        throw new ConfigurationException(msg, e);
                    }
                }
            }
            acceptorConfig.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter(this.getProtocolCodecFactory()));
            try {
                this.acceptor.bind((SocketAddress)new InetSocketAddress(this.serverHostIP, this.port), (IoHandler)this, (IoServiceConfig)acceptorConfig);
                if (this.acceptor.getManagedServiceAddresses().size() != 1 || !(this.acceptor.getManagedServiceAddresses().iterator().next() instanceof InetSocketAddress)) {
                    throw new InternalServiceException("Unable to get the port from the IoAcceptor!");
                }
                this.port = ((InetSocketAddress)this.acceptor.getManagedServiceAddresses().iterator().next()).getPort();
            }
            catch (IOException e) {
                throw new ConfigurationException("The server socket (skeleton) could not be started, because port '" + this.port + "' is already in use. (" + e.toString() + ") " + "Change the port in the configuration" + " (ADEPT2.properties) and try again!");
            }
            String msg = String.format("MINA server started on '%s:%s'.", this.serverHostIP, this.port);
            this.logger.info(msg);
        }
        catch (ConfigurationException ce) {
            this.socketAcceptorExecutor.shutdownNow();
            throw ce;
        }
        catch (RuntimeException re) {
            this.socketAcceptorExecutor.shutdownNow();
            throw re;
        }
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) {
        MinaMessage<?> mm = null;
        Object excp = null;
        if (cause instanceof ProtocolDecoderException) {
            excp = (ProtocolDecoderException)((Object)cause);
            mm = ((ProtocolDecoderException)((Object)cause)).getMinaMessage();
        } else if (cause instanceof ProtocolEncoderException) {
            excp = (ProtocolEncoderException)((Object)cause);
            mm = ((ProtocolEncoderException)((Object)cause)).getMinaMessage();
        }
        if (mm != null && session.isConnected()) {
            session.write(new MinaMessage(mm.getID(), (Exception)excp));
        } else if (cause instanceof IOException) {
            String msg = String.format("'%s' caught an IOException for session '%s'. Therefore the session has been closed. This has probably been done on purpose by the sender of the request.", this.name, session);
            this.logger.log(Level.INFO, msg, cause);
        } else {
            String msg = String.format("'%s' caught an exception for session '%s'. The ID of the corresponding request is unavailable.", this.name, session);
            this.logger.log(Level.WARNING, msg, cause);
        }
    }

    public void normalShutdown() {
        this.acceptor.unbindAll();
        this.serverPool.shutdown();
        this.socketAcceptorExecutor.shutdown();
        AbstractMinaCommunicationService.awaitExecutorServiceShutdown(this.serverPool);
        AbstractMinaCommunicationService.awaitExecutorServiceShutdown(this.socketAcceptorExecutor);
        this.logger.info("Shutdown succeeded!");
    }

    public void emergencyShutdown() {
        this.acceptor.unbindAll();
        this.serverPool.shutdownNow();
        this.socketAcceptorExecutor.shutdownNow();
        AbstractMinaCommunicationService.awaitExecutorServiceShutdown(this.serverPool);
        AbstractMinaCommunicationService.awaitExecutorServiceShutdown(this.socketAcceptorExecutor);
    }

    public int getPort() {
        return this.port;
    }

    @Override
    protected void shutdownStackLayer() {
        super.shutdownStackLayer();
        AbstractMinaCommunicationService.awaitExecutorServiceShutdown(this.socketConnectorExecutor);
    }
}

