/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.mina;

import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.communication.invocation.InvocationMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationReplyMessage;
import de.aristaflow.adept2.base.communication.mina.AbstractMinaClient;
import de.aristaflow.adept2.base.communication.mina.MinaMessage;
import de.aristaflow.adept2.base.communication.mina.MinaObjectSerialisationCodecFactory;
import de.aristaflow.adept2.base.communication.mina.MinaResponseHandler;
import java.util.Map;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;

public class MinaClient
extends AbstractMinaClient<InvocationMessage, InvocationReplyMessage> {
    public MinaClient(String instanceName, long timeout, boolean useSSL, String sslCertFileName, String sslKeystorePass) {
        super(timeout, useSSL, sslCertFileName, sslKeystorePass, String.format("MinaClient (%s)", instanceName), null);
    }

    @Override
    protected ProtocolCodecFactory getProtocolCodecFactory() {
        return new MinaObjectSerialisationCodecFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(IoSession session, Object message) throws CommunicationStackException {
        block15: {
            block14: {
                if (!(message instanceof MinaMessage)) break block14;
                switch (((MinaMessage)message).getType()) {
                    case 2: {
                        MinaResponseHandler handler;
                        String msg;
                        MinaMessage mm = (MinaMessage)message;
                        Map map = this.handlerIDCache;
                        synchronized (map) {
                            msg = String.format("The MinaClient received a response message with the ID '%s'.", mm.getID());
                            this.logger.finest(msg);
                            handler = (MinaResponseHandler)this.handlerIDCache.remove(mm.getID());
                        }
                        if (handler == null) {
                            msg = String.format("The response handler for request '%s' is missing! Timeout reached?", mm.getID());
                            this.logger.info(msg);
                        } else {
                            handler.setResult((InvocationReplyMessage)mm.getMessage());
                        }
                        break block15;
                    }
                    case 3: {
                        MinaResponseHandler handler;
                        String msg;
                        MinaMessage mm = (MinaMessage)message;
                        Map map = this.handlerIDCache;
                        synchronized (map) {
                            msg = String.format("The MinaClient received an exceptional response message with the ID '%s'.", mm.getID());
                            this.logger.finest(msg);
                            handler = (MinaResponseHandler)this.handlerIDCache.remove(mm.getID());
                        }
                        if (handler == null) {
                            msg = String.format("The response handler for request '%s' is missing! Timeout reached?", mm.getID());
                            this.logger.info(msg);
                        } else {
                            handler.setThrowable(mm.getException());
                        }
                        break block15;
                    }
                    default: {
                        String msg = String.format("The Mina_C_Client received a message with an unexpected type (%s).", ((MinaMessage)message).getType());
                        this.logger.warning(msg);
                        throw new CommunicationStackException(msg);
                    }
                }
            }
            String msg = String.format("Unexpected message type on client side: '%s' (expected: MinaMessage).", message.getClass());
            this.logger.severe(msg);
            throw new CommunicationStackException(msg);
        }
    }
}

