/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.mina;

import de.aristaflow.adept2.util.ArgChecks;
import java.io.Serializable;

public class MinaMessage<T>
implements Serializable {
    private static final long serialVersionUID = 3177683624821904873L;
    private final long id;
    private final byte type;
    private final String clientID;
    private final T message;
    private final Exception exception;

    public MinaMessage(byte type, String clientID) {
        ArgChecks.checkForNull(clientID, "MinaMessage.clientID");
        this.type = type;
        this.clientID = clientID;
        this.id = -1L;
        this.message = null;
        this.exception = null;
    }

    public MinaMessage(byte type, long id, T message) {
        ArgChecks.checkForNull(message, "MinaMessage.message");
        this.id = id;
        this.type = type;
        this.message = message;
        this.clientID = null;
        this.exception = null;
    }

    public MinaMessage(long id, Exception exception) {
        ArgChecks.checkForNull(exception, "MinaMessage.exception");
        this.id = id;
        this.type = (byte)3;
        this.exception = exception;
        this.clientID = null;
        this.message = null;
    }

    public MinaMessage(long id, Exception exception, T serialisedException) {
        ArgChecks.checkForNull(exception, "MinaMessage.exception");
        ArgChecks.checkForNull(serialisedException, "MinaMessage.serialisedException");
        this.id = id;
        this.type = (byte)3;
        this.exception = exception;
        this.clientID = null;
        this.message = serialisedException;
    }

    public long getID() {
        return this.id;
    }

    public byte getType() {
        return this.type;
    }

    public String getClientID() {
        return this.clientID;
    }

    public byte[] getClientIDBytes() {
        return this.clientID.getBytes();
    }

    public T getMessage() {
        return this.message;
    }

    public Exception getException() {
        return this.exception;
    }
}

