/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.mina;

import de.aristaflow.adept2.base.communication.mina.MinaMessage;
import de.aristaflow.adept2.base.communication.mina.ProtocolDecoderException;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.serialization.ObjectSerializationDecoder;

public class MinaObjectSerialisationDecoder
extends ObjectSerializationDecoder {
    private final ClassLoader classLoader;
    private int maxObjectSize = Integer.MAX_VALUE;
    private static final Logger logger = LoggerTools.getLogger(MinaObjectSerialisationDecoder.class);

    public MinaObjectSerialisationDecoder() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    protected boolean doDecode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws org.apache.mina.filter.codec.ProtocolDecoderException {
        Object message;
        if (!in.prefixedDataAvailable(4, this.maxObjectSize)) {
            return false;
        }
        try {
            message = in.getObject(this.classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            throw new org.apache.mina.filter.codec.ProtocolDecoderException((Throwable)cnfe);
        }
        if (message instanceof MinaMessage) {
            String type;
            MinaMessage mm = (MinaMessage)message;
            switch (mm.getType()) {
                case 1: {
                    type = "request";
                    break;
                }
                case 2: {
                    type = "response";
                    break;
                }
                case 3: {
                    type = "exceptional response";
                    break;
                }
                case 0: {
                    type = "start";
                    break;
                }
                default: {
                    String msg = String.format("The MinaMessage has an unexpected message type %s!", mm.getType());
                    logger.warning(msg);
                    throw new ProtocolDecoderException(mm, msg);
                }
            }
            String msg = String.format("Decoded %s message with ID (%s).", type, mm.getID());
            logger.finest(msg);
        }
        out.write(message);
        return true;
    }
}

