/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.mina;

import de.aristaflow.adept2.base.communication.mina.MinaMessage;
import de.aristaflow.adept2.base.communication.mina.ProtocolEncoderException;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.serialization.ObjectSerializationEncoder;

public class MinaObjectSerialisationEncoder
extends ObjectSerializationEncoder {
    private static final Logger logger = LoggerTools.getLogger(MinaObjectSerialisationEncoder.class);
    private static final int MAX_PACKET_SIZE = 65536;

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws org.apache.mina.filter.codec.ProtocolEncoderException {
        byte[] temp;
        ByteBuffer buf;
        if (!(message instanceof Serializable)) {
            throw new org.apache.mina.filter.codec.ProtocolEncoderException((Throwable)new NotSerializableException());
        }
        ByteBuffer objectBuffer = ByteBuffer.allocate((int)64);
        objectBuffer.setAutoExpand(true);
        objectBuffer.putObject(message);
        int objectSize = objectBuffer.position() - 4;
        if (objectSize > this.getMaxObjectSize()) {
            objectBuffer.release();
            String msg = String.format("The encoded object is too big: %s (> %s).", objectSize, this.getMaxObjectSize());
            if (message instanceof MinaMessage) {
                throw new ProtocolEncoderException((MinaMessage)message, msg);
            }
            throw new org.apache.mina.filter.codec.ProtocolEncoderException(msg);
        }
        if (message instanceof MinaMessage) {
            String type;
            MinaMessage mm = (MinaMessage)message;
            switch (mm.getType()) {
                case 1: {
                    type = "request";
                    break;
                }
                case 2: {
                    type = "response";
                    break;
                }
                case 3: {
                    type = "exceptional response";
                    break;
                }
                case 0: {
                    type = "start";
                    break;
                }
                default: {
                    String msg = String.format("The MinaMessage has an unexpected message type %s!", mm.getType());
                    logger.warning(msg);
                    throw new ProtocolEncoderException(mm, msg);
                }
            }
            String msg = String.format("Encode %s message with ID (%s) [size=%s].", type, mm.getID(), objectSize);
            logger.finest(msg);
        }
        objectSize = objectBuffer.position();
        objectBuffer.position(0);
        while (objectSize > 65536) {
            buf = ByteBuffer.allocate((int)65536);
            temp = new byte[65536];
            objectBuffer.get(temp, 0, 65536);
            buf.put(temp);
            buf.flip();
            out.write(buf);
            objectSize -= 65536;
        }
        buf = ByteBuffer.allocate((int)objectSize);
        temp = new byte[objectSize];
        objectBuffer.get(temp, 0, objectSize);
        buf.put(temp);
        buf.flip();
        out.write(buf);
        out.mergeAll();
    }
}

