/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.mina;

import de.aristaflow.adept2.base.communication.CommunicationStack;
import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.communication.mina.MinaMessage;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.mina.common.IoSession;

public class MinaRequestHandler<I, O>
implements Runnable {
    private final long id;
    private final I request;
    private final IoSession session;
    private final Logger logger = LoggerTools.getLogger(this);
    private final CommunicationStack<I, O> communicationStack;

    public MinaRequestHandler(long id, I request, IoSession session, CommunicationStack<I, O> communicationStack) {
        this.id = id;
        this.request = request;
        this.session = session;
        this.communicationStack = communicationStack;
    }

    @Override
    public void run() {
        try {
            O message = this.communicationStack.process(null, this.request);
            String msg = String.format("The request handler processed message with id '%s' for session '%s'.", this.id, this.session);
            this.logger.finer(msg);
            this.session.write(new MinaMessage<O>(2, this.id, message));
        }
        catch (CommunicationStackException cse) {
            String msg = "A CommunicationStackException occured during processing and answering a request. Replying with the exception.";
            this.logger.log(Level.INFO, msg, cse);
            this.session.write(new MinaMessage(this.id, cse));
        }
    }
}

