/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.mina;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MinaResponseHandler<T>
implements Future<T> {
    protected final CountDownLatch latch = new CountDownLatch(1);
    protected T result = null;
    protected Throwable throwable;

    public void setResult(T result) {
        this.result = result;
        this.latch.countDown();
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
        this.latch.countDown();
    }

    public T getResult() {
        return this.result;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (this.throwable != null) {
            throw new ExecutionException(this.throwable);
        }
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.latch.await(timeout, unit)) {
            throw new TimeoutException("Unknown reason! " + timeout);
        }
        if (this.throwable != null) {
            throw new ExecutionException(this.throwable);
        }
        return this.result;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() > 0L;
    }
}

