/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.mina;

import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.communication.communicationservices.MinaCommunicationService;
import de.aristaflow.adept2.base.communication.invocation.InvocationMessage;
import de.aristaflow.adept2.base.communication.invocation.InvocationReplyMessage;
import de.aristaflow.adept2.base.communication.mina.AbstractMinaServer;
import de.aristaflow.adept2.base.communication.mina.MinaMessage;
import de.aristaflow.adept2.base.communication.mina.MinaObjectSerialisationCodecFactory;
import de.aristaflow.adept2.base.communication.mina.MinaRequestHandler;
import java.net.InetAddress;
import java.net.URI;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;

public class MinaServer
extends AbstractMinaServer<InvocationMessage, InvocationReplyMessage> {
    public MinaServer(String instanceName, InetAddress serverHostIP, int port, boolean useSSL, String sslCertFileName, String sslKeystorePass, MinaCommunicationService communicationService) {
        super(serverHostIP, port, -1L, useSSL, sslCertFileName, sslKeystorePass, String.format("Mina_Server (%s)", instanceName), communicationService);
    }

    @Override
    protected ProtocolCodecFactory getProtocolCodecFactory() {
        return new MinaObjectSerialisationCodecFactory();
    }

    @Override
    protected InvocationReplyMessage processInputAndReturn(URI remoteObjectIdentifier, InvocationMessage input) throws CommunicationStackException {
        throw new CommunicationStackException("The MinaServer should not be used as a client. The method processInputAndReturn(...) is not implemented!");
    }

    @Override
    protected void shutdownStackLayer() {
    }

    @Override
    public void messageReceived(IoSession session, Object message) throws CommunicationStackException {
        if (!(message instanceof MinaMessage)) {
            String msg = String.format("Unexpected message type on server side: '%s' (expected: MinaMessage).", message.getClass());
            this.logger.severe(msg);
            throw new CommunicationStackException(msg);
        }
        MinaMessage mm = (MinaMessage)message;
        String msg = String.format("The MinaServer received a message with the ID '%s'.", mm.getID());
        this.logger.finest(msg);
        this.serverPool.execute(new MinaRequestHandler(mm.getID(), (InvocationMessage)mm.getMessage(), session, this.communicationService.getSkeletonCommunicationStack()));
    }
}

