/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.mina.single.xs;

import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.communication.communicationservices.AbstractMinaCommunicationService;
import de.aristaflow.adept2.base.communication.communicationservices.Mina_C_XSCommunicationService;
import de.aristaflow.adept2.base.communication.mina.AbstractMinaClient;
import de.aristaflow.adept2.base.communication.mina.MinaMessage;
import de.aristaflow.adept2.base.communication.mina.MinaRequestHandler;
import de.aristaflow.adept2.base.communication.mina.MinaResponseHandler;
import de.aristaflow.adept2.base.communication.mina.xs.MinaXSCodecFactory;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;

public class Mina_C_XSClient
extends AbstractMinaClient<byte[], byte[]> {
    private final ExecutorService clientPool;
    private final Mina_C_XSCommunicationService communicationService;

    public Mina_C_XSClient(String instanceName, long timeout, boolean useSSL, String sslCertFileName, String sslKeystorePass, String clientID, Mina_C_XSCommunicationService communicationService) {
        super(timeout, useSSL, sslCertFileName, sslKeystorePass, String.format("Mina_C_XSClient (%s)", instanceName), clientID);
        this.communicationService = communicationService;
        this.clientPool = Executors.newCachedThreadPool(new Adept2ThreadFactory("Mina_C_XSClientPool"));
    }

    @Override
    protected ProtocolCodecFactory getProtocolCodecFactory() {
        return new MinaXSCodecFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(IoSession session, Object message) throws CommunicationStackException {
        block16: {
            block15: {
                if (!(message instanceof MinaMessage)) break block15;
                MinaMessage mm = (MinaMessage)message;
                switch (mm.getType()) {
                    case 1: {
                        String msg = String.format("The Mina_C_XSClient received a request message with the ID '%s'.", mm.getID());
                        this.logger.finest(msg);
                        this.clientPool.execute(new MinaRequestHandler(mm.getID(), (byte[])mm.getMessage(), session, this.communicationService.getSkeletonCommunicationStack()));
                        break block16;
                    }
                    case 2: {
                        MinaResponseHandler handler;
                        String msg;
                        Map map = this.handlerIDCache;
                        synchronized (map) {
                            msg = String.format("The Mina_C_XSClient received a response message with the ID '%s'.", mm.getID());
                            this.logger.finest(msg);
                            handler = (MinaResponseHandler)this.handlerIDCache.remove(mm.getID());
                        }
                        if (handler == null) {
                            msg = String.format("The response handler for request '%s' is missing! Timeout reached?", mm.getID());
                            this.logger.info(msg);
                        } else {
                            handler.setResult((byte[])mm.getMessage());
                        }
                        break block16;
                    }
                    case 3: {
                        MinaResponseHandler handler;
                        String msg;
                        Map map = this.handlerIDCache;
                        synchronized (map) {
                            msg = String.format("The Mina_C_XSClient received an exceptional response message with the ID '%s'.", mm.getID());
                            this.logger.finest(msg);
                            handler = (MinaResponseHandler)this.handlerIDCache.remove(mm.getID());
                        }
                        if (handler == null) {
                            msg = String.format("The response handler for request '%s' is missing! Timeout reached?", mm.getID());
                            this.logger.info(msg);
                        } else {
                            handler.setThrowable(mm.getException());
                        }
                        break block16;
                    }
                    default: {
                        String msg = String.format("The Mina_C_XSClient received a message with an unexpected type (%s).", mm.getType());
                        this.logger.warning(msg);
                        throw new CommunicationStackException(msg);
                    }
                }
            }
            String msg = String.format("Unexpected message type on client side: '%s' (expected: MinaMessage).", message.getClass());
            this.logger.severe(msg);
            throw new CommunicationStackException(msg);
        }
    }

    @Override
    protected void shutdownStackLayer() {
        this.clientPool.shutdown();
        AbstractMinaCommunicationService.awaitExecutorServiceShutdown(this.clientPool);
        super.shutdownStackLayer();
    }
}

