/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.mina.single.xs;

import de.aristaflow.adept2.base.communication.CommunicationStackException;
import de.aristaflow.adept2.base.communication.communicationservices.Mina_C_XSCommunicationService;
import de.aristaflow.adept2.base.communication.mina.AbstractMinaServer;
import de.aristaflow.adept2.base.communication.mina.MinaMessage;
import de.aristaflow.adept2.base.communication.mina.MinaRequestHandler;
import de.aristaflow.adept2.base.communication.mina.MinaResponseHandler;
import de.aristaflow.adept2.base.communication.mina.xs.MinaXSCodecFactory;
import java.net.InetAddress;
import java.util.Map;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;

public class Mina_C_XSServer
extends AbstractMinaServer<byte[], byte[]> {
    public Mina_C_XSServer(String instanceName, InetAddress serverHostIP, int port, long timeout, boolean useSSL, String sslCertFileName, String sslKeystorePass, Mina_C_XSCommunicationService communicationService) {
        super(serverHostIP, port, timeout, useSSL, sslCertFileName, sslKeystorePass, String.format("Mina_C_XSServer (%s)", instanceName), communicationService);
    }

    @Override
    protected ProtocolCodecFactory getProtocolCodecFactory() {
        return new MinaXSCodecFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(IoSession session, Object message) throws CommunicationStackException {
        block17: {
            block16: {
                if (!(message instanceof MinaMessage)) break block16;
                MinaMessage mm = (MinaMessage)message;
                switch (mm.getType()) {
                    case 0: {
                        this.sessionCache.put(((MinaMessage)message).getClientID(), session);
                        break block17;
                    }
                    case 1: {
                        String msg = String.format("The Mina_C_XSServer received a request message with the ID '%s'.", mm.getID());
                        this.logger.finest(msg);
                        this.serverPool.execute(new MinaRequestHandler(mm.getID(), (byte[])mm.getMessage(), session, this.communicationService.getSkeletonCommunicationStack()));
                        break block17;
                    }
                    case 2: {
                        MinaResponseHandler handler;
                        String msg;
                        Map map = this.handlerIDCache;
                        synchronized (map) {
                            msg = String.format("The Mina_C_XSServer received a response message with the ID '%s'.", mm.getID());
                            this.logger.finest(msg);
                            handler = (MinaResponseHandler)this.handlerIDCache.remove(mm.getID());
                        }
                        if (handler == null) {
                            msg = String.format("The response handler for request '%s' is missing! Timeout reached?", mm.getID());
                            this.logger.info(msg);
                        } else {
                            handler.setResult((byte[])mm.getMessage());
                        }
                        break block17;
                    }
                    case 3: {
                        MinaResponseHandler handler;
                        String msg;
                        Map map = this.handlerIDCache;
                        synchronized (map) {
                            msg = String.format("The Mina_C_XSServer received an exceptional response message with the ID '%s'.", mm.getID());
                            this.logger.finest(msg);
                            handler = (MinaResponseHandler)this.handlerIDCache.remove(mm.getID());
                        }
                        if (handler == null) {
                            msg = String.format("The response handler for request '%s' is missing! Timeout reached?", mm.getID());
                            this.logger.info(msg);
                        } else {
                            handler.setThrowable(mm.getException());
                        }
                        break block17;
                    }
                    default: {
                        String msg = String.format("The Mina_C_XSServer received a message with an unexpected type (%s).", mm.getType());
                        this.logger.warning(msg);
                        throw new CommunicationStackException(msg);
                    }
                }
            }
            String msg = String.format("Unexpected message type on server side: '%s' (expected: MinaMessage).", message.getClass());
            this.logger.severe(msg);
            throw new CommunicationStackException(msg);
        }
    }

    @Override
    public void sessionClosed(IoSession session) {
        String msg = String.format("The session (%s) was closed on server side!", session);
        this.logger.info(msg);
        String key = null;
        this.sessionCacheLock.readLock().lock();
        try {
            for (Map.Entry entry : this.sessionCache.entrySet()) {
                if (!((IoSession)entry.getValue()).equals(session)) continue;
                key = (String)entry.getKey();
            }
        }
        finally {
            this.sessionCacheLock.readLock().unlock();
        }
        if (key != null) {
            this.sessionCacheLock.writeLock().lock();
            try {
                this.sessionCache.remove(key);
                msg = String.format("Removed the session (%s) with key (%s) from the session cache.", session, key);
                this.logger.info(msg);
            }
            finally {
                this.sessionCacheLock.writeLock().unlock();
            }
        }
    }
}

