/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.mina.xs;

import de.aristaflow.adept2.base.communication.mina.MinaMessage;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.logging.Logger;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public class MinaXSDecoder
extends CumulativeProtocolDecoder {
    private static final String TYPE_BYTE = "TypeByte";
    private static final String MSG_ID = "ID";
    private static final String LENGTH = "Length";
    private static final Logger logger = LoggerTools.getLogger(MinaXSDecoder.class);

    protected boolean doDecode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws ProtocolDecoderException {
        String msg;
        Byte typeByte = (Byte)session.getAttribute(TYPE_BYTE);
        Long id = (Long)session.getAttribute(MSG_ID);
        Integer length = (Integer)session.getAttribute(LENGTH);
        boolean messageRead = false;
        if (length == null) {
            length = -1;
        }
        block7: while (in.remaining() > 12 && in.remaining() >= length) {
            if (typeByte == null) {
                typeByte = in.get();
            }
            switch (typeByte) {
                case 0: {
                    byte[] bytes = new byte[in.getInt()];
                    in.get(bytes);
                    out.write(new MinaMessage(0, new String(bytes)));
                    msg = String.format("Decoded start message for %s", session);
                    logger.finer(msg);
                    typeByte = null;
                    messageRead = true;
                    break block7;
                }
                case 1: 
                case 2: 
                case 3: {
                    MinaMessage<Object> message;
                    if (id == null && length == -1) {
                        id = in.getLong();
                        length = in.getInt();
                    }
                    String type = typeByte == 1 ? "request" : (typeByte == 2 ? "response" : "exceptional response");
                    msg = String.format("Decode %s message with ID (%s). (remaining bytes: %s/%s)", type, id, in.remaining(), length);
                    logger.finest(msg);
                    if (in.remaining() < length) continue block7;
                    byte[] bytes = new byte[length.intValue()];
                    in.get(bytes);
                    if (typeByte == 3) {
                        try {
                            message = new MinaMessage(id, this.deserialiseException(bytes));
                        }
                        catch (IOException ioe) {
                            message = new MinaMessage(id, ioe);
                        }
                        catch (ClassNotFoundException cnfe) {
                            message = new MinaMessage<byte[]>(id, cnfe, bytes);
                        }
                    } else {
                        message = new MinaMessage<byte[]>(typeByte, id, bytes);
                    }
                    out.write(message);
                    messageRead = true;
                    msg = String.format("Decoded %s message with ID (%s).", type, id);
                    logger.finer(msg);
                    typeByte = null;
                    id = null;
                    length = -1;
                    break block7;
                }
                default: {
                    session.close();
                    msg = String.format("Unexpected header byte: %s. Closing session.", typeByte);
                    throw new ProtocolDecoderException(msg);
                }
            }
        }
        session.setAttribute(TYPE_BYTE, (Object)typeByte);
        session.setAttribute(MSG_ID, (Object)id);
        session.setAttribute(LENGTH, (Object)length);
        if (typeByte != null || id != null || length != null) {
            msg = String.format("Saved the attributes typeByte (%s), id (%s) and length (%s) in session '%s'.", typeByte, id, length, session);
            logger.finest(msg);
        }
        return messageRead;
    }

    private Exception deserialiseException(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream oi = new ObjectInputStream(bais);
        return (Exception)oi.readObject();
    }
}

