/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.communication.mina.xs;

import de.aristaflow.adept2.base.communication.mina.MinaMessage;
import de.aristaflow.adept2.base.communication.mina.ProtocolEncoderException;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

public class MinaXSEncoder
extends ProtocolEncoderAdapter {
    private static final Logger logger = LoggerTools.getLogger(MinaXSEncoder.class);
    private static final int MAX_PACKET_SIZE = 65536;

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws org.apache.mina.filter.codec.ProtocolEncoderException {
        block8: {
            block7: {
                if (!(message instanceof MinaMessage)) break block7;
                MinaMessage mm = (MinaMessage)message;
                switch (mm.getType()) {
                    case 0: {
                        byte[] bytes = mm.getClientIDBytes();
                        ByteBuffer buffer = ByteBuffer.allocate((int)(5 + bytes.length), (boolean)false);
                        buffer.put(mm.getType());
                        buffer.putInt(bytes.length);
                        buffer.put(bytes);
                        buffer.flip();
                        out.write(buffer);
                        break block8;
                    }
                    case 1: 
                    case 2: {
                        String msg = String.format("Encode %s message with ID (%s) [size=%s].", mm.getType() == 1 ? "request" : "response", mm.getID(), ((byte[])mm.getMessage()).length);
                        logger.finest(msg);
                        long id = mm.getID();
                        byte[] bytes = (byte[])mm.getMessage();
                        this.writeMessage(out, mm.getType(), id, bytes);
                        break block8;
                    }
                    case 3: {
                        byte[] bytes;
                        String msg = String.format("Encode exceptional response message with ID (%s).", mm.getID());
                        logger.finest(msg);
                        long id = mm.getID();
                        try {
                            bytes = this.serialiseException(mm.getException());
                        }
                        catch (IOException ioe) {
                            msg = String.format("Could not serialise an exception for sending as exceptional response message with ID (%s).", mm.getID());
                            throw new ProtocolEncoderException(mm, msg, ioe);
                        }
                        this.writeMessage(out, mm.getType(), id, bytes);
                        break block8;
                    }
                    default: {
                        String msg = String.format("The MinaMessage has an unexpected message type %s!", mm.getType());
                        logger.warning(msg);
                        throw new ProtocolEncoderException(mm, msg);
                    }
                }
            }
            String msg = String.format("Unexpected input type '%s' (expected: MinaMessage).", message.getClass());
            logger.severe(msg);
            throw new org.apache.mina.filter.codec.ProtocolEncoderException(msg);
        }
    }

    private void writeMessage(ProtocolEncoderOutput out, byte messageType, long messageID, byte[] message) {
        ByteBuffer buffer;
        long id = messageID;
        byte[] bytes = message;
        int n = 0;
        while (n + 65536 < bytes.length) {
            if (id != -1L) {
                buffer = ByteBuffer.allocate((int)65549, (boolean)false);
                buffer.put(messageType);
                buffer.putLong(id);
                id = -1L;
                buffer.putInt(bytes.length);
            } else {
                buffer = ByteBuffer.allocate((int)65536, (boolean)false);
            }
            buffer.put(bytes, n, 65536);
            buffer.flip();
            out.write(buffer);
            n += 65536;
        }
        if (id != -1L) {
            buffer = ByteBuffer.allocate((int)(bytes.length + 1 + 4 + 8), (boolean)false);
            buffer.put(messageType);
            buffer.putLong(id);
            buffer.putInt(bytes.length);
        } else {
            buffer = ByteBuffer.allocate((int)(bytes.length - n), (boolean)false);
        }
        buffer.put(bytes, n, bytes.length - n);
        buffer.flip();
        out.write(buffer);
        out.mergeAll();
    }

    private byte[] serialiseException(Exception exception) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(baos);
        oo.writeObject(exception);
        oo.close();
        return baos.toByteArray();
    }
}

